#include "mbed.h"
#include "FXOS8700CQ.h"

void play_song(void);

DigitalOut led_red(LED_RED);
//InterruptIn accel_int_pin(PTC13);  //ACCEL INT2, FRDM-K64F
InterruptIn accel_int_pin(PTD13);  //ACCEL INT2, HEXIWEAR

//FXOS8700CQ fxos(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // SDA, SCL, (addr << 1)  //FRDM-K64F
FXOS8700CQ fxos(PTC11, PTC10, FXOS8700CQ_SLAVE_ADDR0); // SDA, SCL, (addr << 1)  //HEXIWEAR

Serial pc(USBTX, USBRX);

uint8_t motion_detected;
uint8_t not_first_int;

void accel_interrupt(void)
{
    
    if(not_first_int == 1)
    { 
        led_red = 0;  //turn led on
        motion_detected = 1;
    }
        
    fxos.clear_int(); 

    //first time around, set this to a 1
    not_first_int = 1;

}

int main()
{
    pc.baud(9600);
    
    pc.printf("ready to rock!\n");
    not_first_int = 0;    
    motion_detected = 0;
    accel_int_pin.fall(&accel_interrupt);
    led_red = 1;  //turn led off

    accel_int_pin.mode(PullUp);

    fxos.config_int();
    fxos.config_feature();
    fxos.enable();

    while (true) {
    
        if(motion_detected == 1)
        {
        
            pc.printf("motion detected!\n");
            wait(1);            
            led_red = 1;  //turn led off
            motion_detected = 0;
        
            deepsleep();            
        }
   }
}
   