#include "mbed.h"

void recieve_this(void);
void recieve_that(void);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

RawSerial this_way(USBTX,USBRX);  
RawSerial that_way(D1,D0);
 
// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main() {
    
    
    this_way.baud(115200);
    /** attach the callback function to be called whenever a character is received */
    this_way.attach(&recieve_this, Serial::RxIrq);
    ///set the baud rate    
    that_way.baud(115200);
    /** attach the callback function to be called whenever a character is received */
    that_way.attach(&recieve_that, Serial::RxIrq); 
    
    
    while (true) {
        Thread::wait(1000);
    }
}


void recieve_this(void)
{
    ///blink an led for fun
    led1 = !led1;
    /** get a character, then put it back on the other interface */
    that_way.putc(this_way.getc());
    
}
/** get incoming data from second serial interface and put to other
 *  @param none
 *  @returns none
 */        
void recieve_that(void)
{
    ///blink an led for fun
    led2 = !led2;
    /** get a character, then put it back on the other interface */
    this_way.putc(that_way.getc());        
}