#include "mbed.h"

DigitalOut led1(LED1);
InterruptIn sw(SW2);  //Use SW1 on some platforms
Timer timer;

uint8_t recording = 0;  //indicates whether recording a new pattern or not
uint32_t blinkTiming[20] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};  //to store pattern - series of milisecond time delays
uint8_t blinkCount = 0;  //starts at 0 for first knock
uint32_t startTime;  //timer time in miliseconds

//interrupt routine that is called when button is pressed
void fall_handler(void) {

    //if not recording yet
    if(recording ==0)
      {
        //this is the first button press
        blinkCount = 0;
        led1 = 1; //turn off led
        //clear the array that stores the pattern
        for(uint8_t i = 0; i<20; i++)
        {
          blinkTiming[i] = 0;
        }
        //set state to recording
        recording = 1;
        //start timer
        timer.start();
        timer.reset();
        startTime = timer.read_ms();

      //if already recording
      }else if(recording == 1)
      {
        //this is not the first button press
        uint32_t now;
        //check the time verses the start time and save it
        now = timer.read_ms();
        blinkTiming[blinkCount] = (now - startTime);
        //add to the number of button presses captured - same as number of blinks that will come later
        blinkCount++;
        startTime = now;  //start time for next period
      }

}

// main() runs in its own thread in the OS
int main() {

  //set state to not recording
  recording = 0;
  //set interrupt callback for when the button is pressed
  sw.fall(fall_handler);


  while(1)
  {
      //if state is recording
      if(recording==1)
      {
          //check if the max button presses (and thus blinks) has been reached, or time period has expired
          if (blinkCount >= 20 || timer.read_ms() > 5000)  //max presses reached or 5 sec elapsed - done recording
          {
            timer.stop();
            /* re-initialize all variables */
            recording = 0;
            blinkCount = 0;

          }
      //if state not recording
      }else if(recording == 0)
      {
          while(recording == 0)
          {
            //blink out the pattern
            for(uint8_t i = 0;i < 20; i++)
            {
              //blink led
              led1 = 0;
              wait_ms(10);
              led1 = 1;
              //wait for specified delay that was captured
              wait_ms(blinkTiming[i]);
              //check if the delay is zero, if so its the last one so stop.
              if(blinkTiming[i] == 0){
                break;
              }

            }
            //take a break for a few seconds, then loop back and repeat the pattern again
            wait_ms(2000);
          }  //end of while(recording == 0)
      } //end of if(recording == 0)

  }  //end of while(1) infinite loop

}  //end of main
