#include "mbed.h"
#include "MAX1704X.h"

//Create an MAX1704X object at the default address (ADDRESS_0)
MAX1704X battery_level(D14, D15);  //sda, scl

int main()
{
    //Try to open the MAX1704X
    if (battery_level.open()) {
        printf("Device detected!\n");

        while (1) {
            //Print the current battery level
            printf("battery = %d\n", battery_level.read_percent());

            //Sleep for 1 seconds
            wait(1);
        }
    } else {
        error("Device not detected!\n");
    }
}
