/* MAX1704X Simple Driver Library
 * Copyright (c) 2017 Mac Lobdell
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//todo: configure pin interrupt on battery level alert

#include "MAX1704X.h"

MAX1704X::MAX1704X(PinName sda, PinName scl, Address addr, int hz) : m_I2C(sda, scl), m_ADDR((int)addr)
{
    //Set the I2C bus frequency
    m_I2C.frequency(hz);

    write16(REG_CONFIG_H,0x9700);  //set alert to 32%
    
}

bool MAX1704X::open()
{
    //Probe for the I2C Device using a Zero Length Transfer
    if (!m_I2C.write(m_ADDR, NULL, 0)) {
        //Return success
        return true;
    } else {
        //Return failure
        return false;
    }
}

uint32_t MAX1704X::read_ad()
{
  char xm, xl;
  uint32_t temp, xo;
  
  xm = read8(REG_VCELL_H);  //high byte
  xl = read8(REG_VCELL_L);  //low byte
  
  temp = (xl|(xm << 8));
  //alternatively can read16
 //xo = read16(REG_VCELL_H);    //does this work?
  
  xo = 1.25* (temp >>4);

  //returns A/D value in mV
  return xo;
  
}
  
uint16_t MAX1704X::read_config()
{
  char xm, xl;
  uint16_t xo;
  
  xm = read8(REG_CONFIG_H);   //high byte 
  xl = read8(REG_CONFIG_L); //low byte

  xo = xl|(xm << 8);

  //alternatively can read16
//  xo = read16(REG_CONFIG_H);    //does this work?
  
  return xo;  
}

uint32_t MAX1704X::read_percent()
{
  char xm, xl;
  uint32_t xo;
  
  xm = read8(REG_SOC_H);  //high byte
  //xl = read8(REG_SOC_L);  //low byte
  
  //xo = (xl|(xm << 8));
  xo = xm;  //just read out high byte which returns 0-100
            // low byte provides unecessary extra resolution
  //percent_decimal = (0.003906)*xl + xm;

  //returns percent
  return xo;
    
}

 void MAX1704X::power_on_reset(void)
 {

   write8(REG_COMMAND_H, 0x54);
   write8(REG_COMMAND_L, 0x00);

  //alternatively can write16
  //write16(REG_COMMAND_H, 0x5400);  //does this work?
  
 }
/*
//#ifdef MBED_OPERATORS  //this no longer be needed? 
MAX1704X::operator uint32_t()
{
    //Return the current battery percentage
    return read_percent();
}
//#endif
*/
char MAX1704X::read8(char reg)
{
    //Select the register
    m_I2C.write(m_ADDR, &reg, 1, true);

    //Read the 8-bit register
    m_I2C.read(m_ADDR, &reg, 1);

    //Return the byte
    return reg;
}

void MAX1704X::write8(char reg, char data)
{
    //Create a temporary buffer
    char buff[2];

    //Load the register address and 8-bit data
    buff[0] = reg;
    buff[1] = data;

    //Write the data
    m_I2C.write(m_ADDR, buff, 2);
}

uint16_t MAX1704X::read16(char reg)
{
    //Create a temporary buffer
    char buff[2];

    //Select the register
    m_I2C.write(m_ADDR, &reg, 1, true);

    //Read the 16-bit register
    m_I2C.read(m_ADDR, buff, 2);

    //Return the combined 16-bit value
    return (buff[0] << 8) | buff[1];
}

void MAX1704X::write16(char reg, uint16_t data)
{
    //Create a temporary buffer
    char buff[3];

    //Load the register address and 16-bit data
    buff[0] = reg;
    buff[1] = data >> 8;
    buff[2] = data;

    //Write the data
    m_I2C.write(m_ADDR, buff, 3);
}
