#include "mbed.h"
#include "FXOS8700CQ.h"

DigitalOut led(LED_RED);
InterruptIn accel_int_pin(PTC13);  //FRDM-K64F
Serial pc(USBTX, USBRX);
FXOS8700CQ fxos(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); //FRDM-K64F

uint8_t motion_detected;

void accel_interrupt(void)
{
       led = 0;  //turn led on
        motion_detected = 1;
       fxos.clear_int();
}

int main()
{
    pc.baud(9600);
    
    pc.printf("ready to rock!\n");
   
    motion_detected = 0;
    accel_int_pin.fall(&accel_interrupt);
    accel_int_pin.mode(PullUp);
       
    led = 1;  //turn led off

    fxos.config_int();      //enabled interrupts from accelerometer
    fxos.config_feature();  //turn on motion detection
    fxos.enable();          //enable accelerometer

    while (true) {
    
        if(motion_detected == 1)
        {
           wait(1);
        
            led = 1;  //turn led off
            motion_detected = 0;
        
            sleep();            
        }
   }
}
