/*
 * Copyright (c) 2016 ARM Limited. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
 
#include "Adafruit_32x8matrix.h"
 
#define I2C_ADDR1 0x70
#define I2C_ADDR2 0x71
#define ROTATION1 0
#define ROTATION2 2
#define BRIGHTNESS 1
 
I2C i2c(D14, D15);
 
Adafruit_32x8matrix matrix(&i2c, I2C_ADDR1, I2C_ADDR2, ROTATION1, ROTATION2, BRIGHTNESS);
 
int main() {
  char buffer [50];

  while(1)
  { 
        snprintf(buffer, 50, "Hi, how are you today?\0");   //pass in max chars to prevent overflow
        matrix.playText(buffer,strlen(buffer), 1);
                           
        Thread::wait(10000);
    }
 
}
