#include "mbed.h"
#include "Adafruit_LEDBackpack.h"
#include "Adafruit_GFX.h"
 
I2C i2c(D14, D15);

//mpl - something with stdio screwing things up.  need to define serial port to use for debug
Serial pc (USBTX,USBRX);

Adafruit_16x8matrix matrix = Adafruit_16x8matrix(&i2c);
Adafruit_16x8matrix matrix2 = Adafruit_16x8matrix(&i2c); 

void scrollText(char * buffer, uint8_t buf_len);

int main() {

        matrix2.begin(0x71);
        matrix2.clear();
        matrix2.writeDisplay();
        
        matrix.begin(0x70);
        matrix.clear();
        matrix.writeDisplay();
        
        char buffer [50];
        sprintf (buffer, "Hello\0");
        scrollText(buffer,strlen(buffer));

}

void scrollText(char * buffer, uint8_t buf_len)
{
    
    //pc.printf("buffer = %s, len = %d\r\n", buffer, buf_len);
    
    /* code inspired by LOLShield library */
    int xoff=31;/* set offset to the right end of the screen - must be signed*/
    for(int i=0; i< (31 + buf_len*6 +10); i++){ /*scrolling loop*/
         for(int j=0; j<buf_len; j++){ /*loop over all of the chars in the text*/
            if(xoff > 15){
                matrix2.drawChar(xoff + j*6 - 16, 0, buffer[j], 1, 0, 1);
                matrix2.writeDisplay();
            }else
            {
                matrix.drawChar(xoff + j*6, 0, buffer[j], 1, 0, 1);
                matrix.writeDisplay();
                matrix2.drawChar(xoff + j*6 - 16, 0, buffer[j], 1, 0, 1);
                matrix2.writeDisplay();
            }    
        }
        xoff--; /* decrement x offset*/
        Thread::wait(70);
        matrix.clear();
        matrix2.clear();
    }    
}    
