#include "mbed.h"

#include "Adafruit_32x8matrix.h"

Adafruit_32x8matrix::Adafruit_32x8matrix(I2C *i2c, uint8_t i2c_addr, uint8_t i2c_addr2, uint8_t rotation, uint8_t rotation2, uint8_t brightness) 

    : _i2c(i2c), _matrix(_i2c), _matrix2(_i2c), _i2c_addr(i2c_addr), _i2c_addr2(i2c_addr2), _rotation(rotation), _rotation2(rotation2), _brightness(brightness)  

{
              
    _matrix2.begin(_i2c_addr2);
    _matrix2.setBrightness(_brightness);
    _matrix2.setRotation(_rotation2);
    _matrix2.clear();
    _matrix2.writeDisplay();
        
    _matrix.begin(_i2c_addr);
    _matrix.setBrightness(_brightness);
    _matrix.setRotation(_rotation);                   
    _matrix.clear();
    _matrix.writeDisplay();


}

void Adafruit_32x8matrix::scrollText(char * buffer, uint8_t buf_len, uint8_t speed)
{
    
    // code inspired by LOLShield library 
    int xoff=31;// set offset to the right end of the screen - must be signed
    for(int i=0; i< (31 + buf_len*6 +10); i++){ //scrolling loop
         for(int j=0; j<buf_len; j++){ //loop over all of the chars in the text
            if(xoff > 15){
                _matrix2.drawChar(xoff + j*6 - 16, 0, buffer[j], 1, 0, 1);
            }else
            {
                _matrix.drawChar(xoff + j*6, 0, buffer[j], 1, 0, 1);
                _matrix2.drawChar(xoff + j*6 - 16, 0, buffer[j], 1, 0, 1);
            }    
        }
        xoff--; // decrement x offset
                
        _matrix.writeDisplay();
        _matrix2.writeDisplay();
        Thread::wait(1000/speed);
        _matrix.clear();
        _matrix2.clear();
    }    
}    


void Adafruit_32x8matrix::showText(char * buffer, uint8_t buf_len, uint8_t speed)
{
     for(int j=0; j<buf_len; j++){ //loop over all of the chars in the text
        _matrix.drawChar(j*6, 0, buffer[j], 1, 0, 1);
        _matrix2.drawChar(j*6 - 16, 0, buffer[j], 1, 0, 1);
    }
    _matrix.writeDisplay();
    _matrix2.writeDisplay();
    Thread::wait(1000/speed);
    _matrix.clear();
    _matrix2.clear();
 
} 

void Adafruit_32x8matrix::playText(char * buffer, uint8_t buf_len, uint8_t speed)
{
     char words[16][16];   //16 words max, 16 char max in each word
     int word_count = 0;

     for(int k=0; k<16; k++){  //for each word, up to 16
      for(int j=0; j<16; j++){
        words[k][j] = '\0';    //clear all chars
      }
     }

     int k = 0;  //word index
     int m = 0;  //char index in each word
     for(int j=0; j<buf_len; j++){//loop over all of the chars in the text
            if (buffer[j] == ' '){//if space, stop building the word up
              //not required - words[k][m+1] = '\0';  //terminate the string
              //printf("found word: %s\r\n",words[k]);
              k++; //go to next word
              m = 0;
            }
            else{
              if(m < 16) {  //limit chars to 16
                  words[k][m] = buffer[j];  //build up the string of chars to form words
                  m++;  //got to next char
              }    
            }
            if(k >= 16){   //reached max words
               break;
            }
            
     }
     //last word may not have a space at the end that identifies it, so add one to the count
     if(k < 16)
     {
        k++;
     }
     
     //k is the word count now
     word_count = k;
    // printf("words found = %d\r\n",word_count);
    /* for(int n=0; n<k; n++){
         printf("%s\r\n",words[n]);
       }
    */

     //for each word in the string, show it
     for(int p=0; p<word_count; p++){
       if (strlen(words[p]) > 5)   //can fit about 5 chars on the screen at once, if greater use scroll.
       {
         this->scrollText(words[p],strlen(words[p]), 100);
       }
       else{
         this->showText(words[p],strlen(words[p]), 1);
       }
     }


}