#include "mbed.h"
#include "Sinwave.h"


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Sinwave panel_in(p18,1.0,10000);
BusOut channel_select(p23,p22,p21);
AnalogIn panel_out(p20);
AnalogIn volume(p19);
PwmOut buzzar(p24);
//SoftPWM buzzar(p21);
Serial pc(USBTX,USBRX);
Ticker sensing_ticker;
int g_sensing_flag;

void set_sensing_flag(){
    g_sensing_flag = 1;
}
/*
typedef union{
    unsigned char byte;
    struct{
        unsigned char c:1;
        unsigned char d:1;
        unsigned char e:1;
        unsigned char f:1;
        unsigned char g:1;     
    }bit;
}UN_KEY;*/

int main() {
    wait(0.5);
    int channel_state[8];
    float channel_average[8];
    float key[8];
    float thresh[8];
    //float off_volt[8];
    int key_index = 9;
    int last_key_index = 9;
    //float thresh = 0.95/3.3;
    float tone = 440.0;
    int i,j;
    buzzar.period(tone);
    buzzar = 0.25;
    sensing_ticker.attach(&set_sensing_flag,0.10);
    pc.baud(115200);
    channel_select = 0;
    led1 = 0;
    led2 = 0;
    
    key[0] = 1.0/523.51;
    key[1] = 1.0/587.32;
    key[2] = 1.0/659.25;
    key[3] = 1.0/698.45;
    key[4] = 1.0/783.99;
    key[5] = 1.0/880.00;
    key[6] = 1.0/987.5;
    key[7] = 1.0/1047.0;
    
    panel_in.start();
    channel_select = 0;
    wait_ms(1);
    for(i=0;i<8;i++){
        channel_select = i;
        wait_ms(1);
        for(j=0;j<50;j++){
            wait_us(100);
            channel_average[i] += panel_out;
        }
        channel_average[i] = channel_average[i]/50.0;
        thresh[i] = channel_average[i];
        channel_average[i] = 0;
    }
    pc.printf("th1:%.2f",thresh[0]*3.3);
    pc.printf("th2:%.2f",thresh[1]*3.3);
    pc.printf("th3:%.2f",thresh[2]*3.3);
    pc.printf("th4:%.2f",thresh[3]*3.3);
    pc.printf("th5:%.2f",thresh[4]*3.3);
    pc.printf("th6:%.2f",thresh[5]*3.3);
    pc.printf("th7:%.2f",thresh[6]*3.3);
    pc.printf("th8:%.2f\r\n",thresh[7]*3.3);

    while(1) {
        if(g_sensing_flag == 1){
            key_index = 9;
            for(int i=0;i<8;i++){
                channel_select = i;
                wait_ms(1);
                //thresh[i] = volume;
                for(int j=0;j<50;j++){
                    wait_us(100);
                    channel_average[i] += panel_out;
                }
                channel_average[i] = channel_average[i]/50.0;
                //if(channel_average[i]*3.3 < thresh[i]){
                if(channel_average[i] < thresh[i] * (0.6 + volume.read()*0.4)){
                    channel_state[i] = 1;
                    key_index = i;
                }else{
                    channel_state[i] = 0;  
                }
            }
            if(key_index == 9){
                   buzzar = 0.0;
                   
            }else{
                   if(last_key_index != key_index){
                        buzzar.period(key[key_index]);
                        buzzar = 0.25;
                    }  
            }
            last_key_index = key_index;
            led1 = channel_state[0]+channel_state[4];
            led2 = channel_state[1]+channel_state[5];
            led3 = channel_state[2]+channel_state[6];
            led4 = channel_state[3]+channel_state[7];
            pc.printf("volume:%.2f",volume.read());
            
            
            pc.printf("ch1:%.2f",channel_average[0]*3.3);
            pc.printf("ch2:%.2f",channel_average[1]*3.3);
            pc.printf("ch3:%.2f",channel_average[2]*3.3);
            pc.printf("ch4:%.2f",channel_average[3]*3.3);
            pc.printf("ch5:%.2f",channel_average[4]*3.3);
            pc.printf("ch6:%.2f",channel_average[5]*3.3);
            pc.printf("ch7:%.2f",channel_average[6]*3.3);
            pc.printf("ch8:%.2f\r\n",channel_average[7]*3.3);
            
            channel_average[0] = 0;
            channel_average[1] = 0;
            channel_average[2] = 0;
            channel_average[3] = 0;
            channel_average[4] = 0;
            channel_average[5] = 0;
            channel_average[6] = 0;
            channel_average[7] = 0;
            g_sensing_flag = 0;
        }
                 
    }
}
