#ifndef THERMISTOR_H
#define THERMISTOR_H
#include "mbed.h"
#include "math.h"

class Thermistor
{
    public:
        Thermistor(float T0,float R0,float B);   
        float trans_R2T(float R);    //transfer resistance to temperature(degrees)
    private:
        float R0_;     //basic resisitance of thremister at basic temperature 
        float T0_;     //basic temperature[°C]
        float K0_;     //basic temperature[K]
        float B_;      //B constant 
};
#endif
/*
float R2T(float input){
    float K0 = T0+273.0;
    float K =  (B*K0)/(K0*log(input/R0)+B);
    float temp = K-273.0;
    return temp;
    
}*/