#include "TA8429.h"

TA8429::TA8429(PinName in1,PinName in2,float frequency):in1_ (in1),in2_(in2){
    in1_.period(1/frequency);
    in2_.period(1/frequency);
}

void TA8429::set_CW(float duty){
     if(duty < 0.0){
        duty = 0.0;
    }
    if(duty >1.0){
        duty = 1.0;
    }
    in1_ = 1.0;
    in2_ = 1.0-duty;
}
void TA8429::set_CCW(float duty){
    if(duty < 0.0){
        duty = 0.0;
    }
    if(duty >1.0){
        duty = 1.0;
    }
    in2_ = 1.0;
    in1_ = 1.0-duty;
}   
void TA8429::stop(){
    in1_ = 1.0;
    in2_ = 1.0;
}