#include "mbed.h"
#include "Sinwave.h"

Sinwave::Sinwave(PinName DAport,float amplitude,float frequency):DAport_(DAport){
    int i;
    float pi = 3.1415;
    cycle_ = 1.0/(frequency*10.0);
    for(i = 0;i < 10;i++){
        outputs_[i] = amplitude*0.5 * (float)sin(2*pi*frequency*cycle_*i) + 0.5;
    }
}
void Sinwave::update(){
    static int i = 0;
    DAport_.write(outputs_[i]);
    i++;
    i = i % 10;
}
void Sinwave::start(){
     output_int_.attach(this,&Sinwave::update,cycle_);
}
void Sinwave::stop(){
    output_int_.detach();
}
    