#ifndef SERIALMIDI_H_
#define SERIALMIDI_H_
#include"mbed.h"

class SerialMIDI{
    
typedef union{
   char byte;
   struct{
       uint8_t ch_num:4;
       uint8_t order:4;  
   }bit; 
}un_status_byte;

typedef union{
    char byte;
    struct{
        uint8_t data:7;
        uint8_t MSB:1;
    }bit;
}un_data_byte;

    public:
        SerialMIDI(PinName TX, PinName RX);
        void baud(int baudrate);
        void note_on(uint8_t ch_num,uint8_t note_number,uint8_t velocity);
        void note_off(uint8_t ch_num,uint8_t note_number,uint8_t velocity);
    private:
        Serial serial_port_;
        un_status_byte status_byte_;
        un_data_byte data_byte1_;
        un_data_byte data_byte2_;
};

#endif
        
        