#include "mbed.h"
#include "SerialMIDI.h"


SerialMIDI::SerialMIDI(PinName TX,PinName RX):serial_port_(TX,RX){
    serial_port_.baud(115200);
}

void SerialMIDI::baud(int baudrate){
    serial_port_.baud(baudrate);
}

void SerialMIDI::note_on(uint8_t ch_num,uint8_t note_number,uint8_t velocity){
    status_byte_.bit.order = 0x09;
    status_byte_.bit.ch_num = ch_num;
    
    data_byte1_.bit.MSB = 0x00;
    data_byte1_.bit.data = note_number;
    
    data_byte2_.bit.MSB = 0x00;
    data_byte2_.bit.data = velocity;
    
    serial_port_.putc(status_byte_.byte);
    serial_port_.putc(data_byte1_.byte);
    serial_port_.putc(data_byte2_.byte);
};

void SerialMIDI::note_off(uint8_t ch_num,uint8_t note_number,uint8_t velocity){
    status_byte_.bit.order = 0x08;
    status_byte_.bit.ch_num = ch_num;
    
    data_byte1_.bit.MSB = 0x00;
    data_byte1_.bit.data = note_number;
    
    data_byte2_.bit.MSB = 0x00;
    data_byte2_.bit.data = velocity;
    
    serial_port_.putc(status_byte_.byte);
    serial_port_.putc(data_byte1_.byte);
    serial_port_.putc(data_byte2_.byte);
};



