#include "NTCThermistor.h"

/** Create a NTCThermistor instance
*@param T0 basic temperature[degrees/celsious]
*@param R0 basic resistance[ohm]. Thermistor takes this resistance at basic temperature T0.
*@param B B-parameter. 
*/
NTCThermistor::NTCThermistor(float T0,float R0,float B){
    T0_ = T0;
    K0_ = T0_+273.0;
    R0_ = R0;
    B_ = B;
}

/** Transfer temperature from resistance 
*/
float NTCThermistor::trans_R2T(float R){
    float K =  (B_*K0_)/(K0_*log(R/R0_)+B_);
    float temp = K-273.0;
    return temp;
}