#include "bldc.h"
#include "quad_core.h"
bldc::bldc(I2C* i2c, int addr) {
    this->_i2c = new i2c_helper(i2c, addr);
    init_cmd();
}

void bldc::duty(char dutyMSB, char dutyLSB) {
    this->_i2c->write_message( CODE_DUTY, dutyMSB,  dutyLSB, this->cmd);
}

void bldc::init_cmd() {
    unsigned short duty = 15;                // 0 - 150

    unsigned short freq = 11000;            // 11 kHz
    char direction = 0;                     // nu intereseaza
    unsigned short speed = 20;               // freq comutatie intre faze
    
    cmd[0] = speed >> 8;
    cmd[1] = speed;
    
    cmd[2] = (char) duty >> 8;
    cmd[3] = (char) duty;

    cmd[4] = freq >>8;
    cmd[5] = freq;
    
    cmd[6] = direction;
}

bldc::~bldc() {
    delete this->_i2c;
}