#include "i2c_helper.h"

unsigned short duty = 15;                // 0 - 150
unsigned short freq = 11000;            // 11 kHz - pwm frequecny
char direction = 0;                     // motor direction
unsigned short speed = 20;               // bldc phase comutation freq 

i2c_helper::i2c_helper(I2C* i2c, int addr){
    this->addr = addr;
    this->i2c = i2c;
}

int i2c_helper::write_message(char code, char byte1, char byte2, char cmd[]) {
    if( code == 1) {
        duty = (unsigned short)(byte1 << 8) + byte2;
        cmd[2] = (char) duty >> 8;
        cmd[3] = (char) duty;
    } else if ( code == 0 ) {
        speed = (unsigned short)(byte1 << 8) + byte2;
    }

    cmd[0] = speed >> 8;
    cmd[1] = speed;


    cmd[4] = freq >>8;
    cmd[5] = freq;

    cmd[6] = direction;
    return this->i2c->write(this->addr, cmd, 8);
}