/*
Copyright (c) 2011, Senio Networks, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "SimpleSocket.h"

ServerSocket::ServerSocket(int port, bool debug)
        : accepted(false), debug(debug) {
    ssocket.setOnEvent(this, &ServerSocket::onTCPSocketEvent);

    SocketError bindErr = ssocket.bind(Host(IpAddr(), port));
    DBG("Init bind... %s\n", bindErr.toString());

    SocketError listenErr = ssocket.listen();
    DBG("Init listen... %s\n", listenErr.toString());
}

void ServerSocket::onTCPSocketEvent(TCPSocketEvent e) {
    DBG(SocketEvent(e));

    switch (e) {
        case TCPSOCKET_ACCEPT:
            accepted = true;
            break;
        case TCPSOCKET_DISCONNECTED:
            ssocket.close();
            break;
    }
}

ClientSocket ServerSocket::accept(float timeout) {
    TCPSocket* socket = 0;
    Host host;
    timer.reset();
    timer.start();

    do {
        Net::poll();
        if (accepted) {
            accepted = false;
            SocketError err = ssocket.accept(&host, &socket);
            if (!err) {
                IpAddr ip = host.getIp();
                DBG("TCP connection from %d.%d.%d.%d\n", ip[0], ip[1], ip[2], ip[3]);
                break;
            } else {
                DBG("accept error:%s\n", err.toString());
            }
        }
    } while (timer.read() < timeout);

    return ClientSocket(host.getIp(), socket, debug);
}

void ServerSocket::setDebug(bool debug) {
    this->debug = debug;
}