/*
Copyright (c) 2011, Senio Networks, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "SimpleSocket.h"

SocketEvent::SocketEvent(TCPSocketEvent event) : event(event) {}

char *SocketEvent::toString() {
    switch (event) {
        case TCPSOCKET_CONNECTED:
            return "TCPSOCKET_CONNECTED: Connected to host.\n";
        case TCPSOCKET_ACCEPT:
            return "TCPSOCKET_ACCEPT: Client is connected, must call accept() to get a new Socket.\n";
        case TCPSOCKET_READABLE:
            return "TCPSOCKET_READABLE: Data in buf.\n";
        case TCPSOCKET_WRITEABLE:
            return "TCPSOCKET_WRITEABLE: Can write data to buf.\n";
        case TCPSOCKET_CONTIMEOUT:
            return "TCPSOCKET_CONTIMEOUT: Connection timed out.\n";
        case TCPSOCKET_CONRST:
            return "TCPSOCKET_CONRST: Connection was reset by remote host.\n";
        case TCPSOCKET_CONABRT:
            return "TCPSOCKET_CONABRT: Connection was aborted.\n";
        case TCPSOCKET_ERROR:
            return "TCPSOCKET_ERROR: Unknown error.\n";
        case TCPSOCKET_DISCONNECTED:
            return "TCPSOCKET_DISCONNECTED: Disconnected.\n";
        default:
            static char buf[32];
            sprintf(buf, "UNKNOWN EVENT (%d).\n", event);
            return buf;
    }
}

SocketEvent::operator char *() {
    return toString();
}

SocketEvent::operator int() {
    return event;
}

SocketError::SocketError(TCPSocketErr err) : err(err) {};

char *SocketError::toString() {
    switch (err) {
        case TCPSOCKET_SETUP:
            return "TCPSOCKET_SETUP: TCPSocket not properly configured.\n";
        case TCPSOCKET_TIMEOUT:
            return "TCPSOCKET_TIMEOUT: Connection timed out.\n";
        case TCPSOCKET_IF:
            return "TCPSOCKET_IF: Interface has problems, does not exist or is not initialized.\n";
        case TCPSOCKET_MEM:
            return "TCPSOCKET_MEM: Not enough memory.\n";
        case TCPSOCKET_INUSE:
            return "TCPSOCKET_INUSE: Interface/Port is in use.\n";
        case TCPSOCKET_EMPTY:
            return "TCPSOCKET_EMPTY: Connections queue is empty.\n";
        case TCPSOCKET_RST:
            return "TCPSOCKET_RST: Connection was reset by remote host.\n";
        case TCPSOCKET_OK:
            return "TCPSOCKET_OK: Success.\n";
        default:
            return "TCPSOCKET unknown error occurred.\n";
    }
}

SocketError::operator char *() {
    return toString();
}

SocketError::operator int() {
    return err;
}

DatagramEvent::DatagramEvent(UDPSocketEvent event) : event(event) {}

char *DatagramEvent::toString() {
    switch (event) {
        case UDPSOCKET_READABLE:
            return "UDPSOCKET_READABLE: Data in buf.\n";
        default:
            static char buf[32];
            sprintf(buf, "UNKNOWN EVENT (%d).\n", event);
            return buf;
    }
}

DatagramEvent::operator char *() {
    return toString();
}

DatagramEvent::operator int() {
    return event;
}

DatagramError::DatagramError(UDPSocketErr err) : err(err) {};

char *DatagramError::toString() {
    switch (err) {
        case UDPSOCKET_SETUP:
            return "UDPSOCKET_SETUP: UDPSocket not properly configured.\n";
        case UDPSOCKET_IF:
            return "UDPSOCKET_IF: Interface has problems, does not exist or is not initialized.\n";
        case UDPSOCKET_MEM:
            return "UDPSOCKET_MEM: Not enough memory.\n";
        case UDPSOCKET_INUSE:
            return "UDPSOCKET_INUSE: Interface/Port is in use.\n";
        case UDPSOCKET_OK:
            return "UDPSOCKET_OK: Success.\n";
        default:
            return "UDPSOCKET unknown error occurred.\n";
    }
}

DatagramError::operator char *() {
    return toString();
}

DatagramError::operator int() {
    return err;
}