#ifndef __MAX1120X_H__
#define __MAX1120X_H__

#include "mbed.h"

// Status flag
#define NOT_READY       1
#define READY           0

// Start bit
#define START           (1<<7)

// Mode selection
#define MODE_BIT                6
#define REGISTER_OP_BIT         0
#define mode_register_write(x)  ((START | x | (1<<MODE_BIT)) & (~(1<<REGISTER_OP_BIT)) )
#define mode_register_read(x)   (START | x | (1<<MODE_BIT) | (1<<REGISTER_OP_BIT))
#define mode_action(x)          ((START | x) & (~(1<<MODE_BIT)) )

// Mode 0 (action) Actions table
#define ACT_SELF_CAL    0x10
#define ACT_SYS_OFF_CAL 0x20
#define ACT_SYS_GAN_CAL 0x30
#define ACT_POWERDOWN   0x08
#define ACT_CONV_1SPS   0x00
#define ACT_CONV_2_5SPS 0x01
#define ACT_CONV_5SPS   0x02
#define ACT_CONV_10SPS  0x03
#define ACT_CONV_15SPS  0x04
#define ACT_CONV_30SPS  0x05
#define ACT_CONV_60SPS  0x06
#define ACT_CONV_120SPS 0x07

// Mode 1 (command) Registers table
#define RS3             4
#define RS2             3
#define RS1             2
#define RS0             1
#define REG_STAT1       (0x00)                              // Status flags
#define REG_CTRL1       ((1<<RS0))                          // Converter operation settings
#define REG_CTRL2       ((1<<RS1))                          // GPIO pins control
#define REG_CTRL3       ((1<<RS0) | (1<<RS1))               // Gain & Calibration settings
#define REG_DATA        ((1<<RS2))                          // Sample result
#define REG_SOC         ((1<<RS2) | (1<<RS0))               // Offset Sys Calibration value
#define REG_SGC         ((1<<RS2) | (1<<RS1))               // Gain Sys Calibration value
#define REG_SCOC        ((1<<RS2) | (1<<RS1) | (1<<RS0))    // Offset Self-Calibration value
#define REG_SCGC        ((1<<RS3))                          // Gain Self-Calibration value

// Registers' bits
#define STAT1_RDY       (1<<0)
#define STAT1_MSTAT     (1<<1)
#define STAT1_UR        (1<<2)
#define STAT1_OR        (1<<3)
#define STAT1_RATE0     (1<<4)
#define STAT1_RATE1     (1<<5)
#define STAT1_RATE2     (1<<6)
#define STAT1_SYSOR     (1<<7)

#define CTRL1_SCYCLE    (1<<1)
#define CTRL1_FORMAT    (1<<2)
#define CTRL1_SIGBUF    (1<<3)
#define CTRL1_REFBUF    (1<<4)
#define CTRL1_EXTCLK    (1<<5)
#define CTRL1_UNIP_BIP  (1<<6)
#define CTRL1_LINEF     (1<<7)

#define CTRL2_DIR_MASK  0xF0
#define CTRL2_DIO_MASK  0x0F

#define CTRL3_DGAIN_MASK 0xE0
#define CTRL3_NOSYSG    (1<<4)
#define CTRL3_NOSYSO    (1<<3)
#define CTRL3_NOSCG     (1<<2)
#define CTRL3_NOSCO     (1<<1)

// SPI interface configuration
#define MAX1120x_SPI_MODE        3


typedef unsigned int uint;

union UI32toC_t 
{
    char bytes[sizeof(unsigned int)];
    unsigned int value;
};
  
class MAX1120x
{
    SPI *spi;
    DigitalOut *cs;
    DigitalIn *rdy_dout;
    
    public:
        MAX1120x (SPI *, DigitalIn *, DigitalOut *);
        
        // Low-level operations
        void do_self_calibration ();
        void calibrate_system_zero ();
        void calibrate_system_gain ();
        char get_status ();
        void set_control_1 (char);
        char get_control_1 ();
        void set_control_2 (char);
        char get_control_2 ();
        void set_control_3 (char);
        char get_control_3 ();
        unsigned int get_single_sample ();
        unsigned int get_cal_register (char);
        
        // High-level operations
        void init_singlecycle_unipolar_nosyscal ();
};

#endif /*__MAX1120X_H__*/

