#include "MAX1120x.h"

MAX1120x::MAX1120x (SPI *spi_itf, DigitalIn *miso, DigitalOut *cs_pin)
{
    spi = spi_itf;
    cs = cs_pin;
    rdy_dout = miso;
    
    *cs = 1;        // Assert CS high
}

void MAX1120x::do_self_calibration ()
{
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_action(ACT_SELF_CAL));
    *cs = 1;
    wait_ms (202);
}

void MAX1120x::calibrate_system_zero ()
{
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_action(ACT_SYS_OFF_CAL));
    *cs = 1;
    wait_ms(102);
}

void MAX1120x::calibrate_system_gain ()
{
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_action(ACT_SYS_GAN_CAL));
    *cs = 1;
    wait_ms(102);
}

char MAX1120x::get_status ()
{
    char value;
    
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_register_read(REG_STAT1));
    value = (char) spi->write(0);
    *cs = 1;
    
    return value;
}

void MAX1120x::set_control_1 (char ctrl)
{
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_register_write(REG_CTRL1));
    spi->write (ctrl);
    *cs = 1;
}

char MAX1120x::get_control_1 ()
{
    char value;
    
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_register_read(REG_CTRL1));
    value = (char) spi->write(0);
    *cs = 1;
    
    return value;
}

void MAX1120x::set_control_2 (char ctrl)
{
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_register_write(REG_CTRL2));
    spi->write (ctrl);
    *cs = 1;
}

char MAX1120x::get_control_2 ()
{
    char value;
    
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_register_read(REG_CTRL2));
    value = (char) spi->write(0);
    *cs = 1;
    
    return value;
}

void MAX1120x::set_control_3 (char ctrl)
{
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_register_write(REG_CTRL3));
    spi->write (ctrl);
    *cs = 1;
}

char MAX1120x::get_control_3 ()
{
    char value;
    
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_register_read(REG_CTRL3));
    value = (char) spi->write(0);
    *cs = 1;
    
    return value;
}

uint MAX1120x::get_single_sample ()
{
    UI32toC_t sample;
    
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_action(ACT_CONV_1SPS));
    *cs = 1;
    
    wait_ms(1);
    
    *cs = 0;
    while (*rdy_dout) {};    
    spi->write (mode_register_read(REG_DATA));
    sample.bytes[2] = (char) spi->write(0);
    sample.bytes[1] = (char) spi->write(0);
    sample.bytes[0] = (char) spi->write(0);
    *cs = 1;
    sample.bytes[3] = 0;

    return sample.value;
}

uint MAX1120x::get_cal_register (char register_add)
{
    UI32toC_t data;
        
    spi->format (8, MAX1120x_SPI_MODE);
    wait_us (5);
    
    *cs = 0;
    spi->write (mode_register_read(register_add));
    data.bytes[2] = (char) spi->write(0);
    data.bytes[1] = (char) spi->write(0);
    data.bytes[0] = (char) spi->write(0);
    *cs = 1;
    data.bytes[3] = 0;

    return data.value;
}

void MAX1120x::init_singlecycle_unipolar_nosyscal ()
{
    set_control_1 (CTRL1_SCYCLE | CTRL1_SIGBUF | CTRL1_REFBUF | CTRL1_UNIP_BIP);
    set_control_3 (CTRL3_NOSYSG | CTRL3_NOSYSO );    
    do_self_calibration ();
}
