#ifndef __DAC7311_H__
#define __DAC7311_H__

#include "mbed.h"

#define DAC7311_SPI_MODE    1

// Bit masks and shifts
#define PD0                 (1<<14)
#define PD1                 (1<<15)
#define conf_data_12(x)     ((unsigned short)(x << 2) & 0x3FFC)

// Operation modes
#define DAC7311_OP_NORMAL           0    
#define DAC7311_OP_SHUTDOWN_1K      (PD0)
#define DAC7311_OP_SHUTDOWN_100K    (PD1)
#define DAC7311_OP_SHUTDOWN_HIZ     ( PD0 | PD1 )

union UI16toC_t 
{
    char bytes[sizeof(unsigned short)];
    unsigned short value;
};

class DAC7311
{
    SPI *spi;
    DigitalOut *sync;
    unsigned short value;
    unsigned short mode;
    
    public:
        
        DAC7311 (SPI *spi, DigitalOut *sync) : spi(spi), sync(sync), value(0), mode(DAC7311_OP_NORMAL) 
        { *sync = 1; }
        
        void set_mode (unsigned short);
        void set_value (unsigned short);
};


#endif /* __DAC7311_H__ */