#include "DAC7311.h"

void DAC7311::set_mode (unsigned short mode)
{
    this->mode = mode;
    
    spi->format (16, DAC7311_SPI_MODE);
    wait_us (5);
    
    *sync = 0;
    spi->write (mode | conf_data_12(value));
    *sync = 1;
}

void DAC7311::set_value (unsigned short value)
{
    this->value = value;
    
    spi->format (16, DAC7311_SPI_MODE);
    wait_us (5);
    
    *sync = 0;
    spi->write (mode | conf_data_12(value));
    *sync = 1;
}
