#include "mbed.h"
#include "NTPClient.h"
#include "uLCD_4DGL.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
 
//SET UP ULCD
EthernetInterface eth;
uLCD_4DGL uLCD(p28,p27,p11); // serial tx, serial rx, reset pin;
NTPClient ntpClient;
HTTPClient httpClient;
void parse(char buffer[], int *j, char *string); //FUNCTION TO PARSE HTTP GET DATA
char httpGetData[200]; //BUFFER TO HOLD DATA FROM HTTP GET REQUEST
 
 
 
 
int main() {
    time_t ctTime; //system time structure
    uLCD.baudrate(2000000); //Crank up Baudrate
    uLCD.cls();    //Clear uLCD screen
    uLCD.background_color(BLACK); //SET BACKGROUND COLOR TO WHITE
    //SETS THE BACKGROUND COLOR OF TEXT TO WHITE ON THE ULCD
    uLCD.textbackground_color(BLACK);
    uLCD.locate(0,0);  //Start printing on col0, row0
    uLCD.printf("Getting IP Address\n"); //Print to uLCD
    eth.init(); //USE DHCP to get local IP address
    eth.connect(); //Connect to the network
    uLCD.printf("IP ADDRESS is %s\n",eth.getIPAddress()); //Get Ethernet Address and display It on ULCD
    wait(3.0);
    char success[10]={0};  //success first
    char countryFull[20]={0}; //Full Country Name
    char countryAbrv[5]={0}; //Abbreviated Country Name or country Code
    char stateAbrv[5]={0}; //Abbreviated State or region code
    char stateFull[15]={0}; //Full State Name
    char city[15]={0}; //City Name
    char zip[6]={0}; //ZIP CODE
    char latitude[10]={0}; //latitude
    char longitude[10]={0}; //longitude
    char timeZone[30]={0}; //timeZone
    int j=0;
    uLCD.printf("Getting Geolocation Data\n");
    //HANDLES THE HTTP GET REQUEST THE WAY THE FUNCTION IS CALLED HERE IS THE FOLLOWING
    // get(DOMAIN_NAME,BUFFER,TIMEOUT_VAL)
    //DOMAIN_NAME= domain name that get request is sent to
    //BUFFER= buffer to store data returned from the server
    //TIMEOUT_VAL= Time before the request times out
    HTTPResult r = httpClient.get("http://ip-api.com/csv",httpGetData,128); //GET GEOLOCATION DATA (CSV)
    
    if (r==HTTP_OK) { //IF THE DATA WAS RECIEVED
        j=0;
        //parse and display each of the API's location information strings on the LCD
        parse(httpGetData, &j, success); 
        parse(httpGetData,&j,countryFull);
        parse(httpGetData,&j,countryAbrv);
        parse(httpGetData,&j,stateAbrv);
        parse(httpGetData,&j,stateFull);
        parse(httpGetData,&j,city);
        parse(httpGetData,&j,zip);
        parse(httpGetData,&j,latitude);
        parse(httpGetData,&j,longitude);
        parse(httpGetData,&j,timeZone);
        uLCD.cls();
        uLCD.printf("GEOLOCATION DATA RECIEVED\n");  
    } 
    else { //HTTP GET REQUEST ERRORED
        uLCD.cls();
        uLCD.printf("HTTP Error %d", r);
        return -1;
    }
    uLCD.printf("Reading Time...\n");
    char* domainName="us.pool.ntp.org"; //SET TO DOMAIN NAME OF SERVER GETTING TIME FROM
    //GETS THE TIME FROM THE SERVER
    //setTime(DOMAIN_NAME,PORT_NUMBER,TIME_OUT)
    //DOMAIN_NAME= domain name
    //PORT NUMBER=port number (123 for NTP)
    //TIME_OUT= timeout value for request
    ntpClient.setTime(domainName,123,0x00005000);
    uLCD.printf("Time Set\n");
    //Delay for human time to read LCD display
    wait(3.0);
    uLCD.cls();
    //SETS THE BACKGROUND COLOR OF TEXT TO WHITE ON THE ULCD
    uLCD.textbackground_color(BLACK);
    char buffer[80]; //BUFFER TO HOLD FORMATTED TIME DATA
    uLCD.color(BLUE);//SET TEXT COLOR TO BLUE
    uLCD.locate(0,8);
    uLCD.printf("%s, %s %s\n",city,stateAbrv,zip); //PRINT CITY STATE AND ZIP INFORMATION
    uLCD.printf("%s\nLAT:%s\nLONG:%s\n",countryAbrv,latitude,longitude); //PRINT COUNTRY and LATITUDE AND LONGITUDE 
    uLCD.printf("Timezone:\n%s",timeZone); //PRINT TIMEZONE
    uLCD.color(RED);
    eth.disconnect(); //DISCONNECT FROM THE NETWORK 
    uLCD.text_height(2); //2x Text Height
    while (1) {
        // loop and periodically update the LCD's time display
        uLCD.locate(0,0);
        ctTime = time(NULL)-(3600*4);  //TIME with offset for eastern time US
        //FORMAT TIME FOR DISPLAY AND STORE FORMATTED RESULT IN BUFFER
        strftime(buffer,80,"%a %b %d\n%T %p %z\n %Z\n",localtime(&ctTime));
        uLCD.printf("Univ Time Clock\n%s", buffer);
        wait(.1);
    }  
}
 
 
 
 
 
 
//SET FOR CSV FORMAT: NEEDS TO BE EDITED IF DIFFERENT FORMAT
void parse(char buffer[], int *j, char *string) {
//extracts next location string data item from buffer
    int i=0;
    for (i=0; i<=strlen(buffer); i++) {  //TOTAL SIZE OF RETURNED DATA
        if ((buffer[*j+i] == ',')||(buffer[*j+i] == '\0' )) { //IF comma or end of string
            //comma is the string field delimiter
            string[i]=0; //SETS END OF SRTRING TO 0
            *j=*j+i+1; //UPDATES to 1 after comma seperated value
            break;
        } else string[i]=buffer[*j+i]; //Keep adding to the string
    }
}