#include "uLCD_4DGL.h"
#include "bullet.h"
#include "game_synchronizer.h"
#include "globals.h"
#include "math.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "playSound.h"

extern Game_Synchronizer sync;
float et = 0;
int pixelcolor;
//int bouncy

// Initialize the bullet. Don't have to do much here.
// Keep a pointer to this bullet's tank.
// Set the speed, and default the bullet to not in_flight.
Bullet::Bullet(Tank* t) {
    tank = t;
    speed = 0;
    in_flight = false;
}
//Bullet::Bouncy(Tank* t) {
    //tank=t;
    //speed=0;
    //in_flight=false;
//}
// If in_flight, do nothing. Otherwise,
// set the in_flight flag, and initialize values needed for
// the trajectory calculations. (x0, y0), (vx0, vy0), time
// Hint: tank->barrel_end(...) is useful here.
void Bullet::shoot(void) {
    if (in_flight==false){
        in_flight = true;
        tank->barrel_end(&x0,&y0);
        vx0=cos(tank->barrel_theta)*speed;
        vy0=sin(tank->barrel_theta)*speed;
        x=x0;
        y=y0;
        sync.filled_circle(x,y,2,YELLOW);
        sync.filled_circle(x,y,1,ORANGE);
        wait(.5);
        sync.filled_circle(x,y,2,SKY_COLOR);
        sync.filled_circle(x,y,1,BLT_COLOR);
    }
}

// If the bullet is in flight, calculate its new position
// after a time delta dt.
void Bullet::update_position(float dt) {
    if (in_flight == true){
        x=floor(x0+(vx0*dt));
        y=floor(y0+(vy0*dt)-(4.9*dt*dt));
        sync.filled_circle(x,y,1,BLT_COLOR);
    }
}

int Bullet::time_step(float dt) {
    // If the bullet hasn't hit anything, 
    // redraw the bullet at its new location. 
    
    if (in_flight == true){
        sync.filled_circle(x,y,1,SKY_COLOR);
        et += dt;
        update_position(et);
    
    // If it has hit something (obstacle, tank, edge of the screen), 
    // set the in_flight flag back to false, explode the nearby area,
    // and return one of the following codes.
       //if(bouncy==1){
           //if(x>128 || y<0 || y>128){
               
           //}
           //}    
       //else{
       if(x>128 || y<0 || y>128){
          in_flight=false;
          et=0;
          return BULLET_OFF_SCREEN;
    }
    //}
    
    else{
    pixelcolor=sync.read_pixel(x,y);
    
    if(sync.pixel_eq(pixelcolor,BLACK)==1){
        sync.filled_circle(x,y,6, ORANGE);
        sync.filled_circle(x,y,4, YELLOW);
        sync.filled_circle(x,y,2, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,5, ORANGE);
        sync.filled_circle(x,y,3, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,6, SKY_COLOR);
        in_flight=false;
        et=0;
        return pixelcolor;
 
 }
 if(sync.pixel_eq(pixelcolor,TREE)==1){
        sync.filled_circle(x,y,6, ORANGE);
        sync.filled_circle(x,y,4, YELLOW);
        sync.filled_circle(x,y,2, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,5, ORANGE);
        sync.filled_circle(x,y,3, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,6, SKY_COLOR);
        in_flight=false;
        et=0;
        return pixelcolor;
 }
 if(sync.pixel_eq(pixelcolor,GND_COLOR)==1){
        sync.filled_circle(x,y,6, ORANGE);
        sync.filled_circle(x,y,4, YELLOW);
        sync.filled_circle(x,y,2, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,5, ORANGE);
        sync.filled_circle(x,y,3, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,6, SKY_COLOR);
        sync.filled_circle(x,y,6,BROWN);
        sync.filled_circle(x,y+2,6, SKY_COLOR);
        in_flight=false;
        et=0;
        return pixelcolor;
 }
 if(sync.pixel_eq(pixelcolor,WHITE)==1){
        sync.filled_circle(x,y,6, ORANGE);
        sync.filled_circle(x,y,4, YELLOW);
        sync.filled_circle(x,y,2, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,5, ORANGE);
        sync.filled_circle(x,y,3, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,6, SKY_COLOR);
        in_flight=false;
        et=0;
        return pixelcolor;
 }
 if(sync.pixel_eq(pixelcolor,TANK_RED)==1){
        sync.filled_circle(x,y,6, ORANGE);
        sync.filled_circle(x,y,4, YELLOW);
        sync.filled_circle(x,y,2, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,5, ORANGE);
        sync.filled_circle(x,y,3, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,6, SKY_COLOR);
        in_flight=false;
        et=0;
        return pixelcolor;
 }
 if(sync.pixel_eq(pixelcolor,TANK_BLUE)==1){
        sync.filled_circle(x,y,6, ORANGE);
        sync.filled_circle(x,y,4, YELLOW);
        sync.filled_circle(x,y,2, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,5, ORANGE);
        sync.filled_circle(x,y,3, TANK_RED);
        playSound("/sd/wavfiles/Hit.wav");
        sync.update();
        sync.filled_circle(x,y,6, SKY_COLOR);
        in_flight=false;
        et=0;
        return pixelcolor;
 }
 //if(sync.pixel_eq(pixelcolor,BARREL_GREY)==1){
        //sync.filled_circle(x,y,6, ORANGE);
        //sync.filled_circle(x,y,4, YELLOW);
        //sync.filled_circle(x,y,2, TANK_RED);
        //wait(.15);
        //sync.update();
        //sync.filled_circle(x,y,5, ORANGE);
        //sync.filled_circle(x,y,3, TANK_RED);
        //wait(.15);
        //sync.update();
        //sync.filled_circle(x,y,6, SKY_COLOR);
        //in_flight=false;
        //et=0;
        //return pixelcolor;
 }
 
 
 }   
    // return codes:
    //      BULLET_NO_COLLISION: no collision
    //      BULLET_OFF_SCREEN:   off the side of the screen
    //      Otherwise, return the color you've hit in 16bpp format. 
    return BULLET_NO_COLLISION;
}
