#include "tank.h"
#include "globals.h"
#include "math.h"
#include "game_synchronizer.h"
#include "uLCD_4DGL.h"

extern Game_Synchronizer sync;

// sx is the x-coord of the bottom left corner of the tank
// sy is the y-coord of the same corner
// width is the width of the tank
// height is the height of the tank
Tank::Tank(int sx, int sy, int width, int height, int color) {
    x = sx; y = sy;
    w = width; h = height;
    tank_color = color;
    barrel_theta = PI/4.0;
    barrel_length = .75*w;
    wheel_rad = 2.0;
    draw();
}

// Return the minimum x-coord of your tank's bounding box.
int Tank::min_x(void) {
    if(w/2.0+x+barrel_length*cos(barrel_theta)<x){
        return w/2.0+x+barrel_length*cos(barrel_theta);
        }
    else{ 
    return x;
    }
}    

// Return the minimum y-coord of your tank's bounding box.
int Tank::min_y(void) {
    return y+wheel_rad;
}

// Return the maximum x-coord of your tank's bounding box.
int Tank::max_x(void) { 
    if(w/2.0+w+barrel_length*cos(barrel_theta)>x+w){
    return x+w/2+barrel_length*cos(barrel_theta);;
    }
    else{
        return x+w;
        }
}


// Return the maximum y-coord of your tank's bounding box.
int Tank::max_y(void) {  
    return y+h+wheel_rad+barrel_length*sin(barrel_theta);
}

void Tank::barrel_end(int* bx, int* by) {
    // Set the x and y coords of the end of the barrel.
    *bx = x + w/2.0 + barrel_length*cos(barrel_theta); 
    *by = y+h+wheel_rad + barrel_length*sin(barrel_theta);
}

void Tank::reposition(int dx, int dy, float dtheta) {
      
    if(dx!=0 || dy!=0 || dtheta!=0){
        x=x+dx;
        y=y+dy;
        sync.filled_rectangle(x-4, y-1, x+20, y+21, SKY_COLOR);//      Blank out the old tank position, and
        
        sync.filled_circle(53, 26, 6, TREE);
        draw();                                         //      Move the tank dx pixels in the x direction.
        sync.filled_circle(53, 26, 6, TREE);
        //sync.line(76,23,76,50, BLACK);
        //sync.rectangle(74, 20, 75, 50, WHITE);
        sync.filled_circle(78, 19, 4, TREE);            //      Move the tank dy pixels in the y direction.
        sync.update();
    if(0 <= barrel_theta+dtheta && barrel_theta+dtheta <= PI){                          //      Move the tank barrel by an angle dtheta. 
        sync.line(x + w/2.0, y+h+wheel_rad, x + w/2.0 + barrel_length*cos(barrel_theta), y+h+wheel_rad + barrel_length*sin(barrel_theta), SKY_COLOR);//      Don't allow it to go below parallel.
        barrel_theta += dtheta;
        sync.line(x + w/2.0, y+h+wheel_rad, x + w/2.0 + barrel_length*cos(barrel_theta), y+h+wheel_rad + barrel_length*sin(barrel_theta), BLACK);
        sync.filled_rectangle(x+2*wheel_rad, y+3*wheel_rad, x+.65*w, y+h+3*wheel_rad, tank_color);
        sync.update();
    }  
    
    
    //if((x){  //Do collision detection to prevent the tank from hitting things.
      //(x)=x+1;
      //}  
      
    //if(x+16>127){  //Do collision detection to prevent the tank from hitting things.
      //x=111;
      //}
      
      //int obsticle=sync.read_pixel(x+20,y);
      
    //if(sync.pixel_eq(obsticle, SKY_COLOR)!=1){
        //x=x-1;
        //}
    //      (obstacles, side of the screen, other tanks, etc.)
    }
}
    // Example tank draw function. We expect you to get creative on this one!
void Tank::draw() {
    //if(x>4 || x<111){
    sync.line(x + w/2.0, y+h+wheel_rad, x + w/2.0 + barrel_length*cos(barrel_theta), y+h+wheel_rad + barrel_length*sin(barrel_theta), BARREL_GREY);
    sync.filled_circle(x+wheel_rad, y+wheel_rad, wheel_rad, BARREL_GREY);
    sync.filled_circle(x+w-wheel_rad, y+wheel_rad, wheel_rad, BARREL_GREY);
    sync.filled_circle(x+(w/1.475)-wheel_rad,y+wheel_rad, wheel_rad, BARREL_GREY);
    sync.filled_rectangle(x, y+(2*wheel_rad), x+w, y+h+wheel_rad, tank_color);
    sync.filled_rectangle(x+2*wheel_rad, y+3*wheel_rad, x+.65*w, y+h+3*wheel_rad, tank_color);
    sync.line(x+wheel_rad,y-.5*wheel_rad, x+w-wheel_rad, y-.5*wheel_rad, BARREL_GREY);
    sync.line(x+(2*wheel_rad), y+h+wheel_rad, x+.65*w, y+h+wheel_rad, BLACK);
    
    //}
}            