/**
Screensaver functions for the uLCD_4DGL
*/
#include "mbed.h"
#include "uLCD_4DGL.h"
    
/** Determine if the screensaver should be shown */
void uLCD_4DGL :: checkActiveScreenTime() {
    time(&now);
    if (difftime(now, lastDisplayActivityTime) >= max_active_screen_interval) {
        if (!inScreensaverMode) {
            enableScreensaverMode();
        } else if (inScreensaverHysteresis) {
            inScreensaverHysteresis = false;
        }            
    }
}

/** Whenever a change is made to the LCD screen that is not part of the 
 screensaver graphics method, it is reported and the last screen
 activity time is updated */
void uLCD_4DGL :: reportScreenInteraction() {
    time(&lastDisplayActivityTime); // indicate that the screen is still active
    if (inScreensaverMode) {
        exitScreensaverMode();
    }   
}

/** Initialize the screen saver */
void uLCD_4DGL :: enableScreensaverMode() {
    inScreensaverMode = true;
    backupStateOfScreen(); 
    inScreensaverHysteresis = true;
    cls();
    #if MYDEBUG
    pc.printf("Going into screensaver mode\r\n");
    #endif
}

/** Close the screen saver */
void uLCD_4DGL :: exitScreensaverMode() {
    inScreensaverMode = false;
    restoreStateOfScreen();
    inScreensaverHysteresis = false;
    #if MYDEBUG
    pc.printf("Going out of screensaver mode\r\n");
    #endif 
}

/** Set the timeout interval for active screen */
void uLCD_4DGL :: setActiveScreenInterval(int newInterval) {
    max_active_screen_interval = newInterval;   
}

/** Get the timeout interval for active screen */
int uLCD_4DGL :: getActiveScreenInterval() {
    return max_active_screen_interval;   
}

/**Return whether the LCD is currently in screen saver mode */
bool uLCD_4DGL :: isInScreensaverMode() {
    return inScreensaverMode;
}

/** Backup the current pixels of the display to the sd card */
void uLCD_4DGL :: backupStateOfScreen() {
    FILE* data = fopen("/sd/pixelData.txt","w");
    fclose(data);
    data = fopen("/sd/pixelData.txt","a");
    if (data == NULL) {
        pc.printf("Data file failed to open!\r\n"); 
    }
    for (int x = 0; x < 127; x+=2) {
        for (int y = 0; y < 127; y+=2) {
            int color = read_pixel(x, y);
            if (color > 0 && color != 1536 && color != 1538) {
                fprintf(data, "%i %i %i\n", x, y, color);
            }
            
        }   
    }
    fclose(data);
}

// Retrive the backed-up pixel display
// from the sd card
void uLCD_4DGL :: restoreStateOfScreen() {
    cls();
    const int CHARS = 16;
    const int TOKENS = 4;
    const char* const delim = " ";
    
    std::ifstream fin;
    fin.open("/sd/pixelData.txt");
    
    while(!fin.eof()) {
        // int char int char int \n
        // 4 + 1 + 4 + 1 + 4 + 1
        char buf[CHARS];
        fin.getline(buf, CHARS);
        const char* token[TOKENS] = {};
    
        int i=0;
        int color;
        token[0] = strtok(buf, delim);
        if(token[0]) {
            for(i=1; i<TOKENS; i++) {
                token[i] = strtok(0, delim);
                if(!token[i]) break;
                color = atoi(token[2]);
                if (color > 0 && color != 1536 && color != 1538) {
                    int red5 = (color >> 11) & 0x1F;
                    int green6 = (color >> 5) & 0x1F;
                    int blue5 = (color >> 0) & 0x1F;
                    color = 0;
                    color |= blue5 << 0 + 3;
                    color |= green6 << 2 + 8;
                    color |= red5 << 16 + 3;
                    pixel(atoi(token[0]), atoi(token[1]), color);
                } else {
                    pixel(atoi(token[0]), atoi(token[1]), 0);   
                }
            }
        }
    }
    fin.close();
}
