#include "mbed.h"
#include "ultrasonic.h"

DigitalOut dcm01(PTD1);
DigitalOut dcm02(PTD3);
DigitalOut dcm03(PTD2);
DigitalOut dcm04(PTD0);

#if   defined(TARGET_LPC1768)
Serial blue(p9, p10);   // TX, RX
#elif defined(TARGET_KL25Z)
Serial blue(PTE0, PTE1);   // TX, RX
#endif

void dist(int distance)
{   
    blue.printf("%d\r\n", distance);
}

ultrasonic mu(PTD4, PTA4, 0.5, 1, &dist);

int main() {
    
    mu.startUpdates();
    
    dcm01 = 0;
    dcm02 = 0;
    dcm03 = 0;
    dcm04 = 0;
    
    blue.baud(115200);
    
    while(1) {
        if (blue.readable()) 
        {
            char command = blue.getc();
            
            switch (command) 
            {
                // forward
                case 'F':
                    dcm01 = 1;
                    dcm02 = 0;
                    dcm03 = 1;
                    dcm04 = 0;
                    break;
                // backward
                case 'B':
                    dcm01 = 0;
                    dcm02 = 1;
                    dcm03 = 0;
                    dcm04 = 1;
                    break;
                // LEFT
                case 'L':
                    dcm01 = 1;
                    dcm02 = 0;
                    dcm03 = 0;
                    dcm04 = 1;
                    break;
                // right
                case 'R':
                    dcm01 = 0;
                    dcm02 = 1;
                    dcm03 = 1;
                    dcm04 = 0;
                    break;
                // stop
                case 'S':
                    dcm01 = 0;
                    dcm02 = 0;
                    dcm03 = 0;
                    dcm04 = 0;
                    break;
            }
        }
        
        mu.checkDistance();
    }
}
