#include "mbed.h" //MBED library
#include "TextLCD.h" //LCD library
#include "ID12RFID.h" //RFID library
#include "Keypad.h" //Keypad library
#include "emic2.h" //Speech library


emic2 myTTS(p13, p14); //serial RX,TX pins to emic
Serial pc(USBTX, USBRX); // Self Explanatory
ID12RFID rfid(p27); // uart rx 
TextLCD lcd(p15, p16, p21, p22, p23, p24); //rs,e,d0,d1,d2,d3, Digital Out Pins
DigitalIn PhysicalKey(p5); //Digital In pin
Keypad keypad(p7, p12, p11, p9, p8, p6, p10, NC); //Digital out and Digital in Pins for Keypad
DigitalOut Box[2]={p29, p30}; //LED ligts to show what door opens at the end

// Define your own keypad values
char Keytable[] = {'1', '2', '3',   // r0
                   '4', '5', '6',   // r1
                   '7', '8', '9',   // r2
                   '*', '0', '#'}; // r3
                  // c0   c1   c2
        
uint32_t Password[4]={1, 2, 3, 4}; //General Password is 1234
uint32_t PasswordTry[4]; //Where your password attempt is stored
uint32_t Index; //keypad library output from 0 to 11 defined as
                /*
                 {'0', '1', '2',   // r0
                  '3', '4', '5',   // r1
                  '6', '7', '8',   // r2
                  '9', '10', '11'}; // r3
                  // c0   c1   c2
                */
 
uint32_t cbAfterInput(uint32_t index) {
     Index = index;  //the actual output of the library is index, we assign it to Index
     return 0;
}

//Entry Verification Levels
DigitalOut CardAuthorized(LED1); //Authorized Card Notification
DigitalOut PinAuthorized(LED2); //Authorized Pin Notification
DigitalOut QuestionAuthorized(LED3); //Approved Security Question
DigitalOut DoorUnlock(LED4); //Approved Entry

//Stored integers to manipulate security information
int Attempts = 0; //Counts how many times Timer ResetEvertyhing has been triggered, and failures
int CardDATA; //initializes the rfid.read() function early so theres no delay to display the Data
int UserIdentifier = 0; //Self Explanatory
int CorrectNumbersCounter = 0; //Used to count how many inputs of the keypad were correct in Pin section
int CorrectNumbersCounter1 = 0; //Used to count how many inputs of the keypad were correct in Question section
int SongCounter = 0; //Used to count how many correct inputs was entered to initiat the song easter egg
int Card[10]={22352713, 22374742}; //Stored value of RFID Cards
int SongEE[4]= {12, 12, 12, 12}; //Stored value for keypad input to start the song easter egg ####
int CorrectCard = 0; //
char Question[2][64]= {"What is your social security number", //Self Explanatory
                          "How many pets do you own"};
char UserNames[2][10]= {"Marco", //Self Explanatory
                          "Chris"};

uint32_t QuestionAnswers[2][4]={ {5, 5, 5, 5},      //unint32_t is used because keypad library uses it
                                {11, 11, 11, 1} };  //and we need to compare the password to keypad entries
                                //0, 0, 0, 0

void ResetLocks(void); //resets the locks
void ResetLocks(void){
    CardAuthorized = 0;   // Reset Card
    PinAuthorized = 0;  // Reset Pin 
    QuestionAuthorized = 0; //Reset Question Asked Section
    DoorUnlock = 0; //Locks the Door
    CorrectCard = 0; //Resets if a correct card has been detected
    CorrectNumbersCounter = 0; //Resets whether Pin entered matches Pin Answer
    CorrectNumbersCounter1 = 0;//Resets whether Pin entered mathes Question Answer
    UserIdentifier = 0;  //Identfies the User, default being 0, aka Marco
    SongCounter = 0;  //Resets the easter egg 
    Box[0]=0; //Closes the Door 0 for Marco
    Box[1]=0; //Closes the Door 1 for Chris
}

int main(){
    myTTS.volume(18); //max volume 
    keypad.attach(&cbAfterInput);
    keypad.start();  // energize the keypad via c0-c3
    int run_once1 = 0; //neccesary to run a statement once in a while loop
    int run_once2 = 0; //neccesary to run a statement once in a while loop
    int run_once3 = 0; //neccesary to run a statement once in a while loop
    myTTS.voice(2); //sets the voice profile of the speech module 
    
    while(1){ //where the program mainly runs continuously
        while(PhysicalKey == 0) {   //key either not inserted and/or turned
            if (run_once1 == 0){    //run the function below once to avoid spam
                ResetLocks();       //When key isnt inserted, lock everything
                lcd.cls();          //clear screen
                pc.printf("Please Insert Physical Key\n\r");   //Terminal Print
                lcd.printf("Please Insert   Physical Key \n"); //LCD Print
                myTTS.speakf("S Please Insert Physical Key \r");  //S starts speech for desired string, \r ends speech
                myTTS.ready(); //ready waits for speech to finish from last command
                run_once1 = 1;         
            }
        }
        while(PhysicalKey == 1) { //key inserted and turned
            run_once1 = 0;
            if (run_once2 == 0){
                lcd.cls(); //
                pc.printf("Please Scan Card\n\r"); //
                lcd.printf("Please Scan Card \n");
                myTTS.speakf("S Please Scan Card \r"); 
                myTTS.ready(); 
                run_once2 = 1;         
            }
            else if (Attempts > 3) { //if you fail any step more than 3 times, this function startys
                lcd.cls();
                pc.printf("Too many Attempts\n\r");
                lcd.printf("Too many        Attempts\n");
                myTTS.speakf("S Too many Attempts \r"); 
                myTTS.ready(); 
                lcd.cls();
                pc.printf("LOCKED for 30 Minutes\n\r");
                lcd.printf("LOCKED for 30   Minutes\n");
                myTTS.speakf("S Locked for 30 Minutes \r"); 
                myTTS.ready(); 
                
                for(int LockedOut = 30; LockedOut>0; LockedOut--){ //Lockout Timer
                    lcd.cls();
                    lcd.printf("Time Remaining:");
                    lcd.printf("\n%d Minutes", LockedOut);
                    wait(60);
                    }
                Attempts = 0;
            }

            else if((rfid.readable())&&(Attempts < 4)) { //if the RFID Reader has a Value stored and attempts less than 4
                lcd.cls();
                CardDATA = rfid.read();
                pc.printf("RFID Tag Number:%d\n\r",CardDATA);
                lcd.printf("RFID Tag Number:%d\n",CardDATA);
                wait(1);
                for(int Z = 0; Z<100; Z++){
                    if(CardDATA==Card[Z]){
                        UserIdentifier = Z;  //Whatever Z is when the correct card is Scan is the User
                        CorrectCard = CorrectCard + 1; //+1 on counter if anything from CARD[Z] = card read
                    }
                }
                if(CorrectCard == 0){ //enter this function if the wrong card was read
                    lcd.cls();
                    lcd.printf("Incorrect\n"); 
                    pc.printf("Try Again\n\r"); 
                    myTTS.speakf("S Try Again \r"); 
                    myTTS.ready(); 
                    Attempts = Attempts + 1;
                    wait(2);
                } 
                else if(CorrectCard == 1){ //enter this function if the right card was read
                    CorrectCard = 0;
                    lcd.cls();
                    lcd.printf("Card Accepted\n");  
                    pc.printf("Card Accepted\n\r");  
                    wait(2);
                    CardAuthorized = 1;
                    Attempts = 0;
                    ////////////////////Beginning of Keypad Section
                    while ((CardAuthorized == 1)&& (PhysicalKey == 1)) {
                        lcd.cls();
                        lcd.printf("Type Pin: ");
                        pc.printf("Type Pin: ");
                        myTTS.speakf("S Type Common Pin \r"); 
                        myTTS.ready(); 
                        for(int A=0; A<4; A++){ 
                            __wfi();
                            PasswordTry[A]= Index + 1; //Index +1 because index is 0 to 11, instead of 1 to 12
                            lcd.printf("%c", Keytable[Index]); //prints keytable
                            pc.printf("%c", Keytable[Index]);   
                            wait(0.2);
                        }
                        for(int B=0; B<4; B++){
                            if(PasswordTry[B]==Password[B]){
                                CorrectNumbersCounter = CorrectNumbersCounter + 1; //counts how many times Each array equal each other
                                }
                        }
                        for(int Song=0; Song<4; Song++){  //checks if the song array is equal to password try array
                            if(PasswordTry[Song]==SongEE[Song]){
                                SongCounter = SongCounter + 1;
                            }
                        }
                        if(SongCounter == 4){ //plays song
                            lcd.cls();
                            lcd.printf("Easter Egg ON\n");
                            pc.printf("\n\rEaster Egg ON\n\r");  
                            myTTS.speakf("D1\r");//Sing Song Demo
                            myTTS.ready(); //member function wait
                            SongCounter = 0;
                            }
                        else if(CorrectNumbersCounter == 4){ //Continues program if pin is correct
                            SongCounter = 0;
                            lcd.cls();
                            lcd.printf("Pin Accepted\n");
                            pc.printf("\n\rPin Accepted\n\r");  
                            wait(2);
                            PinAuthorized = 1;
                            Attempts = 0;
                        }
                        else if (CorrectNumbersCounter < 4){//if pin is incorrect, adds 1 attempt
                            SongCounter= 0;
                            CorrectNumbersCounter = 0;
                            lcd.cls();
                            lcd.printf("FAIL"); 
                            pc.printf("FAIL");
                            myTTS.speakf("S Incorrect Entry \r"); 
                            myTTS.ready(); 
                            Attempts = Attempts + 1;
                            if(Attempts == 4){
                                ResetLocks();
                            } 
                        }
                        while ((PinAuthorized == 1)&&(PhysicalKey == 1)) { //if the pin turned on Pinauthorized earlier enter funtion
                        //security question section, Everything in this section is identical to the previous section, except for the question part
                            lcd.cls();
                            lcd.printf("Security\n"); 
                            lcd.printf("Question\n"); 
                            pc.printf("Security Question\n\r");                             
                            myTTS.speakf("S Security Question \r"); 
                            myTTS.speakf("\r"); //marks end of speak command
                            myTTS.ready(); 
                            lcd.cls();
                            pc.printf("%s\n\r", Question[UserIdentifier]);                            
                            myTTS.speakf("S %s\r", Question[UserIdentifier]) ; //Earlier we identiified the User, and we ask user based question here
                            myTTS.ready(); 
                            lcd.cls();
                            lcd.printf("Type Answer: \n"); 
                            pc.printf("Type Answer: \n\r");

                            for(int C=0; C<4; C++){  //build array of attempted password
                                __wfi();
                                PasswordTry[C]= Index + 1;
                                pc.printf("%c", Keytable[Index]);
                                lcd.printf("%c", Keytable[Index]);   //same as previous section
                                wait(0.5);
                            }
                            for(int D=0; D<4; D++){ //compares attempt password array with password
                                if(QuestionAnswers[UserIdentifier][D]==PasswordTry[D]){
                                    CorrectNumbersCounter1 = CorrectNumbersCounter1 + 1;
                                }
                            }
                            if(CorrectNumbersCounter1 == 4){ //if correct pass then continue to next process
                                lcd.cls();
                                lcd.printf("Answered\n");
                                lcd.printf("Accepted\n");
                                pc.printf("\n\rAnswer Accepted\n\r"); 
                                myTTS.speakf("S Answer Accepted \r"); 
                                myTTS.ready(); 
                                QuestionAuthorized = 1;
                                Attempts = 0;
                            }
                            else if(CorrectNumbersCounter1 <4) { //fail and +1 on attempt counter
                            CorrectNumbersCounter1 = 0;
                                lcd.cls();
                                lcd.printf("FAIL"); 
                                pc.printf("FAIL");
                                myTTS.speakf("S Incorrect Entry \r"); 
                                myTTS.ready(); 
                                Attempts = Attempts + 1;
                                if(Attempts == 4){
                                    ResetLocks();
                                } 
                            }                            
            
                            while((QuestionAuthorized == 1)){  //where the door opens
                                if(PhysicalKey == 1){
                                    if (run_once3 == 0){
                                        lcd.cls();
                                        myTTS.speakf("S Welcome %s \r", UserNames[UserIdentifier]); //announces user's name
                                        myTTS.ready();     
                                        pc.printf("Please Remove Key\n\r");
                                        lcd.printf("Please Remove   Key\n");
                                        myTTS.speakf("S Please Remove Key \r"); 
                                        myTTS.ready(); //ready waits for speech to finish from last command with a ":" respo
                                        run_once3 = 1;
                                    }
                                }
                                else if(PhysicalKey == 0){ //when key removed go into your door that is now open
                                    run_once3 = 0;
                                    lcd.cls();
                                    pc.printf("Key Removed\n\r");
                                    lcd.printf("Key Removed\n");
                                    wait(2);
                                    DoorUnlock = 1; //indicates that a door has been opened
                                    
                                    Box[UserIdentifier]=1; //opens the specified user's door
                                    
                                    myTTS.speakf("S Seconds until closed \r"); 
                                    myTTS.ready(); 
                                    for(int Y=5; Y>0; --Y){ //counts down to lock the door
                                        lcd.cls();
                                        pc.printf("Door Open For %d Seconds\n\r",Y);
                                        lcd.printf("Door Open For:\n");
                                        lcd.printf("%d Seconds\n",Y);
                                        myTTS.speakf("S %d \r",Y); 
                                        myTTS.ready(); 
                                    }
                                    ResetLocks(); //locks everything
                                    lcd.cls();
                                    pc.printf("Door Locked\n\r");
                                    lcd.printf("Door Locked\n");
                                    myTTS.speakf("S Door Locked \r"); 
                                    myTTS.ready(); 
                                    wait(1);
                                    Attempts = 0;  //resets attempts, exits loop, restarts whole process
                                }
                            }
                        }
                    }
                } 
                } 
                else if (run_once2 == 0){ //enter this function once after key inserted, but it only runs once
                //because of an error this has to be placed after the readible section
                    lcd.cls();
                    pc.printf("Please Scan Card\n\r");
                    lcd.printf("Please Scan Card\n");
                    myTTS.speakf("S Please Scan Card \r"); 
                    myTTS.ready(); 
                    run_once2 = 1;         
                }               
        if(PhysicalKey == 0){ //if card is correct, but key is removed at the same time, the run_once 2 has to be reseted
            run_once2 = 0; //here or it wont do a function later that only runs once, the once that asks for the card
        //for fucntions to operate in the correct order this has to be placed all the way below for now.
        }
        }//Second While Loop Braket
    }// While(1)
}//Main Braket