/*
 * Biblioteke za uvoz:
 */
#include "mbed.h"

/*
 * Definisanje makroa:
 */
 
#define PERIOD 100
#define DUTY_CYCLE 0.75f
#define ZERO 64
#define ONE 121
#define TWO 36
#define THREE 48
#define FOUR 25
#define FIVE 18
#define SIX 2
#define SEVEN 120
#define EIGHT 0
#define NINE 16
/*
 * Globalne promenljive:
 */
 
PwmOut buzz(PA_11);
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
InterruptIn sw1(PC_9);
DigitalOut sel1(PB_6);
DigitalOut sel2(PC_7);
BusOut display(PA_10,PA_9,PA_8,PB_10,PB_5,PB_4,PB_3);
static int update=0;
static float br=0;
/*
 * Deklaracija funkcija:
 */

void ISR_sw1(void);
void screen(int percent);
/*
 * Glavna funkcija:
 */
int main()
{
    sw1.fall(&ISR_sw1);
    while(true)
    {
        
        buzz.period(pot2.read()/200+0.00005);
        buzz.write(pot1.read());
        screen((int)br);
        wait_ms(4);
    }    
}


/*
 * Definicija funkcija:
 */
 void screen(int percent){
     
     switch(percent-percent/10*10){
            case 0:
                sel1.write(1);
                sel2.write(0);
                display.write(ZERO);
                break;
            case 1:
                sel1.write(1);
                sel2.write(0);
                display.write(ONE);
                break;
            case 2:
                sel1.write(1);
                sel2.write(0);
                display.write(TWO);
                break;
            case 3:
                sel1.write(1);
                sel2.write(0);
                display.write(THREE);
                break;
            case 4:
                sel1.write(1);
                sel2.write(0);
                display.write(FOUR);
                break;
            case 5:
                sel1.write(1);
                sel2.write(0);
                display.write(FIVE);
                break;
            case 6:
                sel1.write(1);
                sel2.write(0);
                display.write(SIX);
                break;
            case 7:
                sel1.write(1);
                sel2.write(0);
                display.write(SEVEN);
                break;
            case 8:
                sel1.write(1);
                sel2.write(0);
                display.write(EIGHT);
                break;
            case 9:
                sel1.write(1);
                sel2.write(0);
                display.write(NINE);
                break;
     }
     wait_ms(8);
    switch(percent/10){
            case 0:
                break;
            case 1:
                sel1.write(0);
                sel2.write(1);
                display.write(ONE);
                break;
            case 2:
                sel1.write(0);
                sel2.write(1);
                display.write(TWO);
                break;
            case 3:
                sel1.write(0);
                sel2.write(1);
                display.write(THREE);
                break;
            case 4:
                sel1.write(0);
                sel2.write(1);
                display.write(FOUR);
                break;
            case 5:
                sel1.write(0);
                sel2.write(1);
                display.write(FIVE);
                break;
            case 6:
                sel1.write(0);
                sel2.write(1);
                display.write(SIX);
                break;
            case 7:
                sel1.write(0);
                sel2.write(1);
                display.write(SEVEN);
                break;
            case 8:
                sel1.write(0);
                sel2.write(1);
                display.write(EIGHT);
                break;
            case 9:
                sel1.write(0);
                sel2.write(1);
                display.write(NINE);
                break;
     }
     wait_ms(4);
     
     
}
     
     
     
 void ISR_sw1(){
     br=pot1.read();
     }
