//***  ELEC 3052: APPLIED PROJECT ---------------------------------------------
// Project: Beverage Rover 
//
// initializeHardware.cpp
//
// Desciption:  - initializes PWM pins
//              - initializes Encoder Pins
//                            
//-----------------------------------------------------------------------------

//*****  INCLUDES   **************************************************
#include "mbed.h"
#include "initializeHardware.h"


// initializeHardware: ---------------------------------------------------
// Description: -calls functions to initialize the hardware
// 
// Parameters: n/a
//
// Returns: n/a
//-----------------------------------------------------------------------------
void initializeHardware (void)
{
        initializePWMOutputPins();
        initializeEncoderPins();        
}//eo initializeHardware  ::::::::::::::::::::::::::::::::::::::


// initializePWMOutputPins: ---------------------------------------------------
// Description: -initialize two PWM pins to control each side of the robot:
//                  two motors on each side controlled by one PWM
// Parameters: n/a
//
// Returns: n/a
//-----------------------------------------------------------------------------
void initializePWMOutputPins(void)
{
    PwmOut leftSideMotorPWM (LEFTSIDEMOTOR_PWM);
    PwmOut rightSideMotorPWM (RIGHTSIDEMOTOR_PWM);   
}//eo initializePWMOutputPins  ::::::::::::::::::::::::::::::::::::::


// initializeEncoderPins: -----------------------------------------------------
// Description: -initialize Encoder Pins for each motor
//               
// Parameters: n/a
//
// Returns: n/a
//-----------------------------------------------------------------------------
void initializeEncoderPins(void)
{
/* NOTE: **May change to interrupts**
    if change to interrupts:
    
    InterruptIn M0channelA(M0_CHANNELA);
    InterruptIn M0channelB(M0_CHANNELB);
*/     

    DigitalIn M0channelA (M0_CHANNELA);  //Motor 0 encoder channel A and B
    DigitalIn M0channelB (M0_CHANNELB);
    
    DigitalIn M1channelA (M1_CHANNELA);  //Motor 1 encoder channel A and B
    DigitalIn M1channelB (M1_CHANNELB);
          
    DigitalIn M2channelA (M2_CHANNELA);  //Motor 2 encoder channel A and B
    DigitalIn M2channelB (M2_CHANNELB);
    
    DigitalIn M3channelA (M3_CHANNELA);  //Motor 3 encoder channel A and B
    DigitalIn M3channelB (M3_CHANNELB); 
}//eo initializePWMOutputPins  ::::::::::::::::::::::::::::::::::::::
