#include "motor.hpp"

Motor::Motor(PinName MP, PinName MM): mp(MP), mm(MM){
    mp.period_us(2048);
    mm.period_us(2048);
}

void Motor::out(double pwm){
    if(pwm > 0.0){
        mp = pwm > 0.5 ? 0.5 : pwm;
        mm = 0.0;
    }
    else if(pwm == 0){
        mp = 0.0;
        mm = 0.0;
    }
    else{
        mp = 0.0;
        mm = -pwm > 0.5 ? 0.5 : -pwm;
    }
}