#include "IM315PS4.hpp"

IM315PS4::IM315PS4(PinName TX, PinName RX){
    i = 0;
    flag = false;
    len = 17;
    val = ':';
    data = new uint8_t[len];
    DATA = new uint8_t[8];
    _pc = new Serial(USBTX, USBRX);
    dev = new Serial(TX, RX);
    dev -> baud(19200);
    _pc -> baud(9600);
    dev -> printf("SRST\r\n");
    dev -> attach(callback(this,&IM315PS4::get),Serial::RxIrq);
}

IM315PS4::IM315PS4(PinName TX, PinName RX, int baud){
    i = 0;
    flag = false;
    len = 17;
    val = ':';
    data = new uint8_t[len];
    DATA = new uint8_t[8];
    _pc = new Serial(USBTX, USBRX);
    dev = new Serial(TX, RX);
    dev -> baud(19200);
    _pc -> baud(baud);
    dev -> printf("SRST\r\n");
    dev -> attach(callback(this,&IM315PS4::get),Serial::RxIrq);
}

void IM315PS4::get(){
    if(dev -> readable()){
        data[i] = dev -> getc();
        if(data[i] == val){
            if(i == 0) i++;
            else{
                data[0] = val;
                i = 1;
            }
        }
        else{
            if(i == 0);
            else if(data[i] == ',');
            else i++;
        }
        if(i >= len){
            if(data[0] == val){
                flag = !flag;
                DATA[0] = ASCII(data[1], data[2]);
                DATA[1] = ASCII(data[3], data[4]);
                DATA[2] = ASCII(data[5], data[6]);
                DATA[3] = ASCII(data[7], data[8]);
                DATA[4] = ASCII(data[9], data[10]);
                DATA[5] = ASCII(data[11], data[12]);
                DATA[6] = ASCII(data[13], data[14]);
                DATA[7] = ASCII(data[15], data[16]);
            }
            i = 0;
        }
    }
    else{
        for(int i = 0 ; i < 8 ; i++)DATA[i] = 0;
    }
}

uint8_t IM315PS4::ASCII(uint8_t data1, uint8_t data2){
    uint8_t dat1 = 0;
    uint8_t dat2 = 0;
    if(data1 >= 0x30 && data1 <= 0x39)dat1 = 16 * (data1 - 0x30);
    else if(data1 >= 0x41 && data1 <= 0x46)dat1 = 16 * (data1 - 0x37);
    if(data2 >= 0x30 && data2 <= 0x39)dat2 = data2 - 0x30;
    else if(data2 >= 0x41 && data2 <= 0x46)dat2 = data2 - 0x37;
    return dat1 + dat2;
}

void IM315PS4::button_state(){
    if(up()) _pc -> printf("Up ");
    if(right()) _pc -> printf("Right ");
    if(left()) _pc -> printf("Left ");
    if(down()) _pc -> printf("Down ");
    if(tri()) _pc -> printf("Tri ");
    if(circle()) _pc -> printf("Circle ");
    if(square()) _pc -> printf("Square ");
    if(cross()) _pc -> printf("Cross ");
    if(l1()) _pc -> printf("L1 ");
    if(l2An() != 0)_pc -> printf("L2:%2x ", l2An());
    if(l3()) _pc -> printf("L3 ");
    if(r1()) _pc -> printf("R1 ");
    if(r2An() != 0)_pc -> printf("R2:%2x ", r2An());
    if(r3()) _pc -> printf("R3 ");
    if(option()) _pc -> printf("OPTIONS ");
    if(share()) _pc -> printf("SHARE ");
    if(ps()) _pc -> printf("PS ");
    if(touchpad()) _pc -> printf("TOUCHPAD ");
    if(lsx() != 127) _pc -> printf("LSX:%3d ", lsx());
    if(lsy() != 127) _pc -> printf("LSY:%3d ", lsy());
    if(rsx() != 127) _pc -> printf("RSX:%3d ", rsx());
    if(rsy() != 127)_pc -> printf("RSY:%3d ", rsy());
    _pc -> printf("\n");
}
void IM315PS4::data_print(){_pc -> printf("%2x %2x %2x %2x %2x %2x %2x %2x\n", DATA[0], DATA[1], DATA[2], DATA[3], DATA[4], DATA[5], DATA[6], DATA[7]);}

bool IM315PS4::available(){
    return flag;
}

bool IM315PS4::up(){return DATA[1] & UP ? 1 : 0;}

bool IM315PS4::right(){return DATA[1] & RIGHT ? 1 : 0;}

bool IM315PS4::left(){return DATA[1] & LEFT ? 1 : 0;}

bool IM315PS4::down(){return DATA[1] & DOWN ? 1 : 0;}

bool IM315PS4::tri(){return DATA[0] & TRI ? 1 : 0;}

bool IM315PS4::circle(){return DATA[0] & CIRCLE ? 1 : 0;}

bool IM315PS4::square(){return DATA[0] & SQUARE ? 1 : 0;}

bool IM315PS4::cross(){return DATA[0] & CROSS ? 1 : 0;}

bool IM315PS4::touchpad(){return DATA[0] & TOUCHPAD ? 1 : 0;}

bool IM315PS4::ps(){return DATA[0] & PS ? 1 : 0;}

bool IM315PS4::l1(){return DATA[0] & L1 ? 1 : 0;}

bool IM315PS4::r1(){return DATA[0] & R1 ? 1 : 0;}

bool IM315PS4::option(){return DATA[1] & OPTION ? 1 : 0;}

bool IM315PS4::share(){return DATA[1] & SHARE ? 1 : 0;}

bool IM315PS4::l3(){return DATA[1] & L3 ? 1 : 0;}

bool IM315PS4::r3(){return DATA[1] & R3 ? 1 : 0;}

uint8_t IM315PS4::l2An(){return DATA[2];}

uint8_t IM315PS4::r2An(){return DATA[3];}

uint8_t IM315PS4::lsx(){return DATA[4];}

uint8_t IM315PS4::lsy(){return DATA[5];}

uint8_t IM315PS4::rsx(){return DATA[6];}

uint8_t IM315PS4::rsy(){return DATA[7];}

IM315PS4::~IM315PS4(){
    delete data;
    delete DATA;
    delete dev;
    delete _pc;
}