#include "IM315.hpp"

IM315::IM315(PinName TX, PinName RX){
    i = 0;
    len = 17;
    val = 0x3a;
    data = new unsigned char[len];
    DATA = new unsigned char[8];
    _pc = new Serial(USBTX, USBRX);
    dev = new Serial(TX, RX);
    dev -> baud(19200);
    _pc -> baud(9600);
    dev -> printf("SRST\r\n");
    dev -> attach(callback(this,&IM315::get),Serial::RxIrq);
}

IM315::IM315(PinName TX, PinName RX, int baud){
    i = 0;
    len = 17;
    val = 0x3a;
    data = new unsigned char[len];
    DATA = new unsigned char[8];
    _pc = new Serial(USBTX, USBRX);
    dev = new Serial(TX, RX);
    dev -> baud(19200);
    _pc -> baud(baud);
    dev -> printf("SRST\r\n");
    dev -> attach(callback(this,&IM315::get),Serial::RxIrq);
}

void IM315::get(){
    if(dev -> readable()){
        data[i] = dev -> getc();
        if(data[i] == val){
            if(i == 0) i++;
            else{
                data[0] = val;
                i = 1;
            }
        }
        else{
            if(i == 0);
            else if(data[i] == ',');
            else i++;
        }
        if(i >= len){
            if(data[0] == val){
                DATA[0] = ASCII(data[1], data[2]);
                DATA[1] = ASCII(data[3], data[4]);
                DATA[2] = ASCII(data[5], data[6]);
                DATA[3] = ASCII(data[7], data[8]);
                DATA[4] = ASCII(data[9], data[10]);
                DATA[5] = ASCII(data[11], data[12]);
                DATA[6] = ASCII(data[13], data[14]);
                DATA[7] = ASCII(data[15], data[16]);
            }
            i = 0;
        }
    }
    else{
        for(int i = 0 ; i < 8 ; i++)DATA[i] = 0;
    }
}

unsigned char IM315::ASCII(unsigned char data1, unsigned char data2){
    unsigned char dat1 = 0;
    unsigned char dat2 = 0;
    if(data1 >= 0x30 && data1 <= 0x39)dat1 = 16 * (data1 - 0x30);
    else if(data1 >= 0x41 && data1 <= 0x46)dat1 = 16 * (data1 - 0x37);
    if(data2 >= 0x30 && data2 <= 0x39)dat2 = data2 - 0x30;
    else if(data2 >= 0x41 && data2 <= 0x46)dat2 = data2 - 0x37;
    return dat1 + dat2;
}

void IM315::button_state(){_pc -> printf("U: %d, D: %d, R: %d, L: %d, TRI: %d, X: %d, O: %d, SQU: %d, L1: %d, L2: %d, R1: %d, R2: %d, STA: %d, SEL: %d, L3: %3d, R3: %3d LSX: %3d, LSY: %3d, RSX: %3d, RY: %3d\n",up(), down(), right(), left(), tri(), cross(), circle(), square(), l1(), l2(), r1(), r2(), start(), select(), l3(), r3(), lsx(), lsy(), rsx(), rsy());}

void IM315::data_print(){_pc -> printf("%2x %2x %2x %2x %2x %2x %2x %2x\n", DATA[0], DATA[1], DATA[2], DATA[3], DATA[4], DATA[5], DATA[6], DATA[7]);}

bool IM315::up(){return DATA[2] & UP ? 1 : 0;}

bool IM315::right(){return DATA[2] & RIGHT ? 1 : 0;}

bool IM315::left(){return DATA[2] & LEFT ? 1 : 0;}

bool IM315::down(){return DATA[2] & DOWN ? 1 : 0;}

bool IM315::tri(){return DATA[1] & TRI ? 1 : 0;}

bool IM315::circle(){return DATA[1] & CIRCLE ? 1 : 0;}

bool IM315::square(){return DATA[1] & SQUARE ? 1 : 0;}

bool IM315::cross(){return DATA[1] & CROSS ? 1 : 0;}

bool IM315::l2(){return DATA[1] & L2 ? 1 : 0;}

bool IM315::r2(){return DATA[1] & R2 ? 1 : 0;}

bool IM315::l1(){return DATA[1] & L1 ? 1 : 0;}

bool IM315::r1(){return DATA[1] & R1 ? 1 : 0;}

bool IM315::start(){return DATA[2] & START ? 1 : 0;}

bool IM315::select(){return DATA[2] & SELECT ? 1 : 0;}

bool IM315::l3(){return DATA[2] & L3 ? 1 : 0;}

bool IM315::r3(){return DATA[2] & R3 ? 1 : 0;}

char IM315::lsx(){return DATA[4];}

char IM315::lsy(){return DATA[5];}

char IM315::rsx(){return DATA[6];}

char IM315::rsy(){return DATA[7];}

IM315::~IM315(){
    delete data;
    delete DATA;
    delete dev;
    delete _pc;
}