#ifndef IM315_H
#define IM315_H
#include "mbed.h"

//DATA[1]
#define TRI      0x01
#define CIRCLE   0x02
#define SQUARE   0x04
#define CROSS    0x08
#define L2       0x10
#define R2       0x20
#define L1       0x40
#define R1       0x80

//DATA[2]
#define UP       0x01
#define RIGHT    0x02
#define LEFT     0x04
#define DOWN     0x08
#define START    0x10
#define SELECT   0x20
#define L3       0x40
#define R3       0x80

/*IM315を用いてPS2コントローラ(DS2)を使う *受信
  例 L432KC用IM315接続基盤の場合
  IM315 ds2(D1, D0);                           マイコン ~ PC間のボーレート指定なし(9600)
  IM315 ds2(D1, D0, 115200);                   マイコン ~ PC間のボーレート指定あり
  
  
  DS2はArduino Nano用読み取り基盤を用いてボタンの状態を読み取り下記のような8バイトの文字列データ(16進数表記)にして送信してください
 /-------------------------------------------- 
  DATA[0]           0x80固定
  DATA[1]           上の表に対応するように
  DATA[2]           上の表に対応するように
  DATA[3]           0x00固定
  DATA[4] ~ DATA[7] 左右スティックのアナログ値 4 -> LスティックのX値 5 -> LスティックのY値 6, 7 -> Rスティックで同様
  
  例 80010400FF808080    △ボタンと十字左ボタンが押され、Lスティックを最大まで右に倒した場合
 /--------------------------------------------
 
 
 /---------- sbdbtライブラリとの相違点 ----------
  ・ニュートラル関数がない(スティックのニュートラル値が定まらずほぼ機能していない)
  ・L2 R2ボタンがアナログで使用不可能
  ・L3 R3ボタン(スティック押し込み)が使用可能
  ・スティックの入力範囲が 0 ~ 255 となっている
  ・スティックの初期値(ニュートラル値)は 0x7f ~ 0x80(127 ~ 128)だと思われる 定まらない(ハードウェア上の問題?)
 /--------------------------------------------
 
*/

class IM315{
public:
    IM315(PinName TX, PinName RX);              //マイコン ~ PC間のボーレート指定なし(9600)
    IM315(PinName TX, PinName RX, int baud);    //マイコン ~ PC間のボーレート指定あり
    void button_state();                        //全ボタン, スティックの状態表示
    void data_print();
    bool up();
    bool right();
    bool left();
    bool down();
    bool tri();
    bool circle();
    bool square();
    bool cross();
    bool l2();
    bool r2();
    bool l1();
    bool r1();
    bool start();
    bool select();
    bool l3();
    bool r3();
    char lsx();
    char lsy();
    char rsx();
    char rsy();
    ~IM315();
private:
    Serial *dev;
    Serial *_pc;
    unsigned char *data;
    unsigned char *DATA;
    void get();
    unsigned char ASCII(unsigned char data1, unsigned char data2);
    int i;
    int val;
    int len;
};
#endif