#ifndef I2CPS4_H
#define I2CPS4_H
#include "mbed.h"

enum Button {
  UP, RIGHT, LEFT, DOWN,
  TRIANGLE, CIRCLE, SQUARE, CROSS,
  L1, R1,
  L3, R3,
  OPTIONS, SHARE, PS, TOUCHPAD,
  L2, R2,
  LSX, LSY,
  RSX, RSY
};

class I2CPS4{
public:
    I2CPS4(PinName SDA, PinName SCL, uint8_t ID);
    void button_state();
    bool available();
    bool up();
    bool right();
    bool left();
    bool down();
    bool triangle();
    bool circle();
    bool square();
    bool cross();
    bool l1();
    bool r1();
    bool l3();
    bool r3();
    bool options();
    bool share();
    bool touchpad();
    bool ps();
    uint8_t l2();
    uint8_t r2();
    uint8_t lsx();
    uint8_t lsy();
    uint8_t rsx();
    uint8_t rsy();
private:
    I2C _i2c;
    void Data_Send(uint8_t name);
    uint8_t data;
    uint8_t id;
};
#endif