#include "I2CPS4.hpp"

I2CPS4::I2CPS4(PinName SDA, PinName SCL, uint8_t ID) : _i2c(SDA, SCL){
    _i2c.frequency(400000);
    id = ID << 1;
}

void I2CPS4::Data_Send(uint8_t name){
    _i2c.write(id, (char *)&name, 1, true);
    _i2c.read(id, (char *)&data, 1);
}

void I2CPS4::button_state(){
    if(up()) printf("Up ");
    if(right()) printf("Right ");
    if(left()) printf("Left ");
    if(down()) printf("Down ");
    if(triangle()) printf("Triangle ");
    if(circle()) printf("Circle ");
    if(square())  printf("Square ");
    if(cross())  printf("Cross ");
    if(l1())  printf("L1 ");
    if(l2() != 0) printf("L2:%2x ", l2());
    if(l3())  printf("L3 ");
    if(r1())  printf("R1 ");
    if(r2() != 0) printf("R2:%2x ", r2());
    if(r3())  printf("R3 ");
    if(options())  printf("OPTIONS ");
    if(share())  printf("SHARE ");
    if(ps())  printf("PS ");
    if(touchpad())  printf("TOUCHPAD ");
    if(lsx() != 127)  printf("LSX:%3d ", lsx());
    if(lsy() != 127)  printf("LSY:%3d ", lsy());
    if(rsx() != 127)  printf("RSX:%3d ", rsx());
    if(rsy() != 127) printf("RSY:%3d ", rsy());
     printf("\n");
}

bool I2CPS4::available(){
    data = 0;
    Data_Send(255);
    return data;
}
bool I2CPS4::up(){
    data = 0;
    Data_Send(UP);
    return data;
}

bool I2CPS4::right(){
    data = 0;
    Data_Send(RIGHT);
    return data;
}

bool I2CPS4::left(){
    data = 0;
    Data_Send(LEFT);
    return data;
}

bool I2CPS4::down(){
    data = 0;
    Data_Send(DOWN);
    return data;
}

bool I2CPS4::triangle(){
    data = 0;
    Data_Send(TRIANGLE);
    return data;
}

bool I2CPS4::circle(){
    data = 0;
    Data_Send(CIRCLE);
    return data;
}

bool I2CPS4::square(){
    data = 0;
    Data_Send(SQUARE);
    return data;
}

bool I2CPS4::cross(){
    data = 0;
    Data_Send(CROSS);
    return data;
}

bool I2CPS4::touchpad(){
    data = 0;
    Data_Send(TOUCHPAD);
    return data;
}

bool I2CPS4::ps(){
    data = 0;
    Data_Send(PS);
    return data;
}

bool I2CPS4::l1(){
    data = 0;
    Data_Send(L1);
    return data;
}

bool I2CPS4::r1(){
    data = 0;
    Data_Send(R1);
    return data;
}

bool I2CPS4::options(){
    data = 0;
    Data_Send(OPTIONS);
    return data;
}

bool I2CPS4::share(){
    data = 0;
    Data_Send(SHARE);
    return data;
}

bool I2CPS4::l3(){
    data = 0;
    Data_Send(L3);
    return data;
}

bool I2CPS4::r3(){
    data = 0;
    Data_Send(R3);
    return data;
}

uint8_t I2CPS4::l2(){
    data = 0;
    Data_Send(L2);
    return data;
}

uint8_t I2CPS4::r2(){
    data = 0;
    Data_Send(R2);
    return data;
}

uint8_t I2CPS4::lsx(){
    data = 0;
    Data_Send(LSX);
    return data;
}

uint8_t I2CPS4::lsy(){
    data = 0;
    Data_Send(LSY);
    return data;
}

uint8_t I2CPS4::rsx(){
    data = 0;
    Data_Send(RSX);
    return data;
}

uint8_t I2CPS4::rsy(){
    data = 0;
    Data_Send(RSY);
    return data;
}