#include "mbed.h"
#include "ODriveLibTest.h"

// Serial to the ODrive
Serial odrive_serial(p9, p10); //TX (ODrive RX), RX (ODrive TX)
Serial PC(USBTX, USBRX); //
// Note: you must also connect GND on ODrive to GND on Arduino!

// ODrive object
ODriveLibTest odrive(odrive_serial);

int main()
{
    // ODrive uses 115200 baud
    odrive_serial.baud(115200);

    // Serial to PC
    PC.baud(115200);
    while (!PC) ; // wait for Arduino Serial Monitor to open

    PC.printf("ODriveArduino");
    PC.printf("Setting parameters...");

    odrive.SetLimit(0, 22000.0f, 50.0f);
    odrive.SetLimit(1, 22000.0f, 50.0f);
    odrive.ODriveInit(0);
    odrive.ODriveInit(1);
    
    PC.printf("Ready!");

    while(1) {
        if (PC.readable()) {
            char c = PC.getc();
            
            if( c == 'm' ) {
                odrive.SetVelocity(0, 12000);
                odrive.SetVelocity(1, 12000);
            } else if( c == 'n' ) {
                odrive.SetVelocity(0, 1200);
                odrive.SetVelocity(1, 1200);
            } else if( c == 's' ) {
                odrive.SetVelocity(0, 0);
                odrive.SetVelocity(1, 0);
            }
        }
    }

}