// Description: Runs Two Tank
// Date: 3FEB2018

// Add important libraries

#include "mbed.h"
#include "mbedWSEsbc.h"

// Declare objects
Ticker Controller; //declares ticker interrupt object called controller

// Declare variables
float TotalTime; // Total run time (specified by user)
float Time; // current elapsed time
float Volt1, Volt2;//voltage tank1,2
float dc;//Duty Cycle
float dc_op; //operating duty cycle
float dc_delta; //duty cycle change
float alpha1, alpha2;//calibration parameters
float beta1, beta2;
float height_op1, height_op2;
float K1, K2;//State feedback gain
int indicator=1;//parameter indicating identification or state feedback
float Tank1, Tank2;//pressure of tanks
float h1,h2;
float dct;
//float speed; //speed of motor
float Tstrm = 1.00; //data streaming period (100 Hz)
//float ang; //angular position of DC motor
//float angp = 0.0; //initialize previous angle to zero
//float errp = 0.0; //initialize previous error to zero
//long enc1; //encoder count variable
//float Ts = 0.0083; //seconds, control update period
//float dc;
//float desired_speed; //desired speed specified by user
//float a; //Tustin's value
//float zero; //PI zero

// Declare functions
void Control(); //declare that a separate function (other than main) exists
void ctrlr_sf(); //declare state feedback function
//void twoStep();
//void pctrl();
//void PIctrl();
//void sends nothing back, () takes no inputs

// Create Main function
int main()
{
    mbedWSEsbcInit(115200); //initialize ES3XX board (declares pc object, motors, encoders, etc)
    mot_en1.period(0.02); //sets pwm period to 0.02 sec for best DC motor operation
    mot_control(1,0); //send opposite duty cycle to pump
    while(1) {
    pc.scanf("%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %d", &TotalTime, &dc_op, &dc_delta, &alpha1, &alpha2, &beta1, &beta2, &height_op1, &height_op2, &K1, &K2, &indicator); //scans serial port for user specified run time and duty cycle
//Declare
        //dc_op=0.3; // 10 -15 centimeters
        //dc_delta=0.01;
//Calibration parameters
       // alpha1=1;
       // alpha2=1;
       // beta1=0;
       // beta2=0;
       // height_op1=12.6;   //observed operating height
       // height_op2=12.6;   //observed operating height
       // K1=2.59;           //State feedback gain
       // K2=2.59;           //State feedback gain
       // indicator=1;      //System ID or State Feedback
       
        Time = 0.0; //set elapsed time to 0
        t.reset(); //reset stop watch to sample from the timer object
        t.start(); //start stop watch to measure elapsed time
        Controller.attach(&ctrlr_sf, Tstrm); //attaches ticker to control function
        while(Time<=TotalTime) {
//read time from stop watch
            Time = t.read();
//send data over the serial port
            pc.printf("%f, %f, %f, %f\n", Time, Tank1, Tank2, dc);
            wait (Tstrm);
            //Control();
        }//end of while(Time<=TotalTime)

        Controller.detach(); //detaching function from ticker to stop experiment
        mot_control(1,0.0); //turns off motor, (references channel 1 where the motor is connected to and duty cycle is now set to 0.0)

    }//end of while(1)

}//end of main program
void ctrlr_sf ()
{
    // Read pressure sensors
    Tank1 = read_max1270_volts(1, 1, 1);
    Tank2 = read_max1270_volts(0, 1, 1);

    // Convert pressure voltage to tank height
    h1 = alpha1*Tank1 + beta1;
    h2 = alpha2*Tank2 + beta2;

    // duty cycle
    dct = -(K1*(h1-height_op1)+K2*(h2-height_op2)); // SF law
    dc = -(dc_op+dct);                // duty cycle must be negative
    

    // saturation
    if (dc > 1.0) {
        dc = 1.0;
    }

    if (dc < -1.0) {
        dc = -1.0;
    }

}
// Define Functions (write the code for what each function does)
/*void Control()
{
    Tank1=read_max1270_volts(1,1,1);
    Tank2=read_max1270_volts(0,1,1);
    h1=alpha1*Tank1+beta1;
    h2=alpha2*Tank2+beta2;
    if (Time<=(TotalTime/2)) {
        dc=dc_op;
        mot_control(1,-dc); //send opposite duty cycle to pump
    } else if (Time>(TotalTime/2)) {
        dc=dc_op+dc_delta;
        mot_control(1,-dc); //send opposite duty cycle to pump
    }
    // }

}
*/