/*************************************************************************************
Program Name: ES202 Laboratory Experiment 4, week 1

Description:
This program takes two values (the number of measurements to collect out and the motor
pwm) from a user. The program then collects the prescribed number measurements
and sends the iteration stamped values across the serial port.
NOTE: YOU MUST CHANGE THE PWM PERIOD IN THE MOTOR.CPP FILE! CHANGE TO _pwm.period_us(50);
Author: Levi DeVries, PhD, USNA, 2/1/17
**************************************************************************************/

#include "mbed.h"
#include "Motor.h"

Serial pc(USBTX,USBRX);   // serial comms with PC

// ENTER CORRECT PIN NUMBER HERE
AnalogIn sensor(p20);    // analog sensor

// ENTER CORRECT MOTOR PINS HERE
Motor mot(p26,p30,p29);   // motor object

int counter;      // counter variable to print across serial port
int Ncnts = 0;    // number of iterations to count to
float aval = 0.0; // analog measurement value
float mDC = 0.0;  // motor duty cycle
float dheight=0.0;
float meas_height;
float height_error;
int main()
{
    pc.baud(115200); // baud rate

    while(1) {
        mot.speed(0.0);  // turn motor off at start of program

        pc.scanf("%d,%f",&Ncnts,&dheight);
        // ENTER CODE HERE TO READ NUMBER OF COUNTS AND DUTY CYCLE FROM SERIAL PORT!!!


        counter = 1; // set counter to 1 for new experiment
        while(counter<=Ncnts) {

            aval=sensor.read();// Read from sensor
            meas_height = 568.3*pow(aval,3) - 797.8*pow(aval,2) + 381*pow(aval,1) - 41; //polyfit funciton coefficients used to accurately model the height
            height_error = dheight - meas_height; //determine the distance between the desired height and actual height
            // logic control
            if(height_error > 1.0) { //when the elevator is greater than 1 inch below the desired height
                mDC = 1.0; //drive the elevator up
            } else if(height_error < -1.0) { //when the elevator is greater than one inch above the desired height
                mDC = -1.0; //drive the elevator down
            } else { //if the elevator is between 1 inch above and 1 inch below the desired height
                mDC = 0.0; // stop the elevator by turning off the DC Motor
            }

            pc.printf("%d,%f,%f\n",counter,meas_height,mDC);
            mot.speed(mDC);// ENTER CODE HERE TO SET MOTOR DUTY CYCLE

            //pc.printf("%d,%f,%f\n",counter,aval,mDC);// PRINT ITERATION #, SENSOR MEASUREMENT, AND DUTY CYCLE TO SERIAL PORT




            counter++; // update counter
            wait(0.05); // wait 0.05 seconds to allow sensor to refresh

        } // end while(counter)
    }// end while(1)
} // end main