#include "mbed.h"
#include "Motor.h"
#include "Servo.h"
#include "PinDetect.h"
 
Motor m(p25, p27, p28);

DigitalIn sw1(p16);
DigitalIn sw2(p17);
DigitalIn sw3(p18);
DigitalIn sw4(p19);
DigitalIn sw5(p20);
PinDetect push1(p12);
PinDetect push2(p13);
Servo servo1(p22);
Servo servo2(p21);

BusOut lights(p5, p6, p7, p8, p11);

float a;
float b;

int volatile count=0;

// Callback routine is interrupt activated by a debounced pb1 hit
void push1_hit_callback (void)
{

    if (a > 0) {

        servo1 = 0;
        wait(.2);
        servo1 = 0.5;

    } else if (a < 0) {

        servo1 = 1;
        wait(.2);
        servo1 = 0.5;

    }

}
// Callback routine is interrupt activated by a debounced pb2 hit
void push2_hit_callback (void)
{

    if (a > 0) {

        servo2 = 0;
        wait(.2);
        servo2 = 0.5;

    }

    else if (a < 0) {

        servo2 = 1;
        wait(.2);
        servo2 = 0.5;
    }

}
int main()
{

    servo1 = 0.5;
    servo2 = 0.5;

    // Use internal pullups for pushbutton
    push1.mode(PullUp);
    push2.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    push1.attach_deasserted(&push1_hit_callback);
    push2.attach_deasserted(&push2_hit_callback);
    // Start sampling pb inputs using interrupts
    push1.setSampleFrequency();
    push2.setSampleFrequency();
    //Blink myled in main routine forever while responding to pb changes
    // via interrupts that activate the callback counter function

    servo1 = 0.5;
    servo2 = 0.5;
    servo1.calibrate (.0009, 90);
    servo2.calibrate (.0009, 90);

    while(1) {

        a = rand()/(float)RAND_MAX*(-1.0)+0.4;
        b = rand()/(float)RAND_MAX*5.0 +3.0;

        if(sw1 == 1 && sw2!= 1 && sw3 != 1 && sw4 != 1) {  //player1



            if(a>=.28 || a <= -.28) {

                servo2 = 0;
                
                lights = 31; // LED 1 on
                wait(.125); // Wait .4 seconds
                lights= 0;

                m.speed(a);
                wait(b);



            }
        } else if(sw1 != 1 && sw2== 1 && sw3 != 1 && sw4 != 1) { //player2
            if(a>=.28 || a <= -.28) {
                lights = 31; //
                wait(.125); //
                lights = 0; //

                m.speed(a);
                wait(b);

            }
        } else if(sw1 != 1 && sw2!= 1 && sw3 == 1 && sw4 != 1 && sw5 != 1) { //player3
            if(a>=.28 ) {

                lights = 31; // LED 1&2&3&4&5 on
                wait(.125); //Wait .4 seconds
                lights = 0; //LED 1&2&3&4 on

                m.speed(a);
                wait(b);

            }
        } else if(sw1 != 1 && sw2!= 1 && sw3 == 1 && sw5 ==1 && sw4 != 1) { //player3
            if(a>=.28 ) {

                lights = 31; // LED 1&2&3&4&5 on
                wait(.125); //Wait .4 seconds
                lights = 0; //LED 1&2&3&4 on

                m.speed(-a);
                wait(b);

            }
        } else if(sw4 == 1 && sw1 != 1 && sw2!= 1 && sw3 == 1 && sw5 ==1 || sw4 == 1 && sw1 != 1 && sw2!= 1 && sw3 == 1 || sw4 == 1 && sw1 != 1 && sw2== 1 && sw3 != 1 || sw4 == 1 && sw1 == 1 && sw2!= 1 && sw3 != 1 || sw4 == 1 && sw1 != 1 && sw2!= 1 && sw3 != 1 ) { //player3

            m.speed(0);
            lights = 31; // LED 1&2&3 on
            wait(.125); //Wait .4 seconds
            lights = 0; //LED 1&2 on
            wait(.125); //Wait .4 seconds
            lights = 31; //LED 1 on
            wait(.125); //Wait .4 seconds
            lights = 0; //LED 1&2 on
            wait(.125); //Wait .4 seconds
            lights = 31; //LED 1 on
            wait(.125); //Wait .4 seconds
            lights = 0; //LED 1&2 on
            wait(.125); //Wait .4 seconds

        }
    }
}