#include "mbed.h"
#include "Servo.h"
#include "Timer.h"

DigitalIn pixhawk(LED1);
Servo gas(p21);
Servo brake(p22);
Timer timer;
float delta;

int main()
{
    while(1) {
        // read pulseIn
        while (!pixhawk); // wait for high 1 or -1
        timer.reset();
        timer.start();
        while (pixhawk); // wait for low
        timer.stop();
        delta = timer.read_us(); //provides pwm on time in microseconds

        if(delta > 0) {
            gas = delta*1000; // convert to PWM signal for gas
        } else if(delta <= 0 && delta > 0.33) {
            brake = -.4; // light braking
        } else {
            brake = -1; // full brake
        }
    }
}