//MIDN 2/C Chau
//Take a temp reading from sensor and send it to MatLab for analysis
//ES305 Lab2
#include "mbed.h"
#include "mbedWSEsbc.h"

float dt; // total change in time
float totaltime = 5; // total sampling time
float Ts = 0.01; // sampling period
int repeat = 17; //Boolean for yes or no
float Time = 0; // time object
float measurement = 0; //The measured voltage of the thermocouple

int main()
{
    mbedWSEsbcInit(19200); //set baud rate
    Time = 0; // reset time var
    t.reset(); // reset time object
    pc.printf("Enter 1 to begin the loop:\n\r");
    pc.scanf("%d", &repeat);
    pc.printf("Enter total sampling time(sec):\n\r");
    pc.scanf("%f", &totaltime);
    pc.printf("Enter sampling period(sec):\n\r");
    pc.scanf("%f", &Ts);
    while (repeat ==1)
    {
        Time = 0; // reset time var
        t.reset(); // reset time object
        
        while (Time <= totaltime)
        {
            t.start(); // start timing object
        
            measurement = read_max1270_volts(6,0,0); //read from the device
            pc.printf("%f,%f\n", Time, measurement); // print measurement
        
            Time = Time + Ts; // increment time
        
            dt = Ts - t.read(); // calculate elapsed time
            wait(dt); // wait
        
            t.reset(); //restart timing object     
        }
        pc.printf("Enter 1 to begin the loop:\n\r");
        pc.scanf("%d", &repeat);
        pc.printf("Enter total sampling time(sec):\n\r");
        pc.scanf("%f", &totaltime);
        pc.printf("Enter sampling period(sec):\n\r");
        pc.scanf("%f", &Ts);
    } 
}