#include "mbed.h"
#include "QEI.h"
#include "Motor.h"

Serial pc(USBTX, USBRX);
//Use X4 encoding.
//QEI wheel(p29, p30, NC, 624, QEI::X4_ENCODING);
//Use X2 encoding by default.
QEI spin(p16, p15, NC, 1600); //p16 is Channel B is 16, Channel A is 17
Motor m(p23, p26, p22);
DigitalOut gun[2]= {p25,p21};

Timer t;

int main()
{
    pc.baud(115200); // set baudrate for communication
    float theta=0.0;
    float old_E=0.0;
    float old_DC=0.0;
    float E=0.0;
    float Ts=0.01;
    float t_log=0.0;
    float r=1.0;
    float DC=0.0;
    float desired_theta=0;
    float anglediff=10;
    float angle_diff;
    t.start();
    while(r==1.0) {
        if (t.read()-t_log>=Ts) { //Ts=sample time
            //measure theta
           // anglediff=0;
            /*if (pc.readable()) {
                pc.scanf("%f", &anglediff); // take matlab value for angle move and put into anglediff
                spin.reset();
                //pc.scanf("%f", &n); //n shots
            }
            */
            anglediff=40;
            n=3;
            
            theta=spin.getPulses()*((-360.0)/3200.0); //random letter
            desired_theta=anglediff;
            //if (desired_theta<0)
            //{
            //desired_theta=-desired_theta;
            //}
            //calculate position error
            E=desired_theta-theta; //angle to turn to move center of target to center of image
            //control algorithm
            DC=0.9481*old_DC +0.01516*E-0.01504*old_E;
            angle_diff=old_E-E;
            if ((fabs(E)>5.0)&&(fabs(angle_diff)<3.0)) {
                if(DC>0) {
                    DC=DC+0.02;     //0.7;    //DC+0.025;
                } else {
                    DC=DC-0.040;//-0.6;         //DC-0.030;
                }
            }
            //move motor
            m.speed(DC);
            pc.printf("DC %f   E =%f \n",DC,E);

              // Age variables
              old_E=E;
            old_DC=DC;
            t_log=t.read();
        }
    }
    t.stop();
}


