/*************************************************************************************
Program Name: ES305 Laboratory Experiment 2, Part 1 - mbed serial setup and streaming
Description: A basic code to read an analog channel and print the data to the serial port

Date: 8/9/2016
**************************************************************************************/

// Include necessary libraries
#include "mbed.h"
#include "mbedWSEsbc.h"
#define PI (3.14159)


// Declare necessary objects
DigitalOut myled(LED1); 


// variables for data handling and storage
float Ts; // Sampling period 1/Ts Hz
float TotalTime; // Total run time
float ang,angp,speed; // variables for approximating speed from encoder measurements
float dc; // duty cycle applied to motor
long enc1; // encoder variable
float Time; // elapsed time
float dt; // desired loop duration
float DC; // duty cycle specified by user



int main ()
{
    // Initializes mbed to access functionality of encoder, A/D, driver, etc. chipsets
    // Input is baud rate for PC communication
    mbedWSEsbcInit(115200); // also initializes timer object t
    mot_en1.period(0.020); // sets PWM period to 0.02 seconds

    while(1) {
        
        // Wait for user input to begin loop
        pc.scanf("%f,%f,%f",&TotalTime,&Ts,&DC);
        
        Time = 0.0; // reset time variable
        t.reset(); // reset timer object

        
        
        angp = 0; // initialize previous angle variable to zero

        myled = 1; // turn on light to indicate it's sampling
        
        while(Time <= TotalTime) {
            t.start(); // start measuring comp time

            // Read encoder
            enc1 = LS7366_read_counter(1); // input is the encoder channel
            pc.printf("counts = %f\n\r",enc1);

            // Convert from counts to radians
            ang = 2*PI*enc1/6500.0;

            // Estimate speed
            speed = (ang-angp)/Ts;

            // Age variables
            angp = ang;

            // compute duty cycle for motor using proportional control scheme
            if(Time<0.1) {
                dc = 0.0;
            } else {
                dc = DC;
            }

            // motor control
            mot_control(1,dc); // first input is the motor channel, second is duty cycle 


            pc.printf("%f,%f,%f\n\r",Time,speed,dc);


            Time = Time + Ts;  // update time

            // wait to achieve sampling rate
            dt = Ts - t.read();
            if(dt<0.0) {
                dt = 0.0;
            }
            wait(dt);

            t.reset();
        
              
        } // end while(Time<=Ttime)
        mot_control(1,0.0); // turn motor off at end of test
        myled = 0; // turn off light to indicate it has finished
        
    }// end while(repeat==1)
}// end main