//#include "mbed.h"
#include "QEI.h"
#include "time.h"

QEI encoder(p25,p24,NC,1600);

DigitalOut direction(p21);
PwmOut speed(p22);

int main() {
    float CurrentTheta;
    int location;
    float CurrentTime = 0.0;
    int i = 0;
    int p = 0;
    float Angle[500]; //Radians
    float Time[500]; //Seconds
    float w[500]; //Radians/second
    Angle[0] = 0.0;
    Time[0] = 0.0;
    w[0] = 0.0;
    i =1;
          
    Timer t;
    
    
//Motor Initialize    
    float dc;
    int dir;
    speed.period(1.0/20.0e3);
    

    //For Direction 1 = CW and 0 =CCW
    printf("Enter duty cycle between 0 and 100. Enter Direction 1 or 0.\n");
    scanf("%f %d", &dc, &dir);
    dc = (dc/100); 
    speed = dc;
    direction = dir;
    
    
    
        
        t.start();
        while(i < 500)
        {
            CurrentTime = t.read();
            location = encoder.getPulses();
            CurrentTheta = (location/(1600.0*2.0)*2.0*3.14); //in Radians
            Angle[i] = CurrentTheta;
            Time[i] = CurrentTime;
            w[i]=(Angle[i]-Angle[i-1])/(Time[i]-Time[i-1]);  //Radians/Second
            wait(0.01); //Setting the interval so we have 5 seconds of data
            
            i++;
        } 
        
        speed = 0;
        
        for(p=0; p < 500; p++)
        {
            printf("%f,%f, %f\n\r", Angle[p], Time[p], w[p]); //Print the time and the current angle and angular velocity
        } 
        printf("Complete");
              
        
}