#include "mbed.h"
#include "uLCD_4DGL.h"
// uncomment this line to enable the uLCD for Part 4 of the lab
uLCD_4DGL lcd(p28, p27, p30);
Serial pc(USBTX, USBRX);

void setup()
{
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    
    //lcd.printf("Initializing...");

    //Make sure communication is working
}

int main() {
    set_time(1256729737);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
    setup();
    
    while (true) {
        time_t seconds = time(NULL);
        
        printf("Time as seconds since January 1, 1970 = %d\n", seconds);
        
        printf("Time as a basic string = %s", ctime(&seconds));
        
        lcd.cls();
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        printf("Time as a custom formatted string = %s", buffer);
        //lcd.set_font(FONT_12X16);
        //lcd.text_mode(OPAQUE);
        //lcd.locate(0,0);
        //lcd.printf(buffer);
        //lcd.text_string(buffer,2,2,FONT_12X16, RED);
        //lcd.text_string("This is a test of string", 1, 4, FONT_12X16, BLUE);
    lcd.text_width(3); //4X size text
    lcd.text_height(3);
    lcd.color(RED);
    //lcd.set_font(MEDIAFONT);
    //lcd.text_bold(ON);
    lcd.locate(0,2);
    lcd.printf(buffer);
    //lcd.text_char('B', 4, 4, RED);
    //lcd.text_char('I',10, 8, RED);
    //lcd.text_char('G',11, 8, RED);
        wait(1);
    }
}
