#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include <vector>
#include <stdlib.h>
#include <time.h>

DigitalIn yes(p5);
DigitalIn no(p6);
uLCD_4DGL lcd(p28, p27, p30);
Mutex mutex; 
LocalFileSystem local("local");  

void setup()
{
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    lcd.text_width(3); //4X size text
    lcd.text_height(3);
    //lcd.printf("Initializing...");
    lcd.text_string("Initializing...", 0,0,FONT_8X12,BLUE);
}

void timer(void const *in) {
    int* timeNo = (int*) in;
    lcd.filled_rectangle(0,90,100,95,RED);
    for (int i = 10; i>=0; i--) {
        mutex.lock();
        lcd.locate(8,10);
        lcd.printf("00:%02d", i);
        lcd.filled_rectangle(i*10,90,(i+1)*10,95,BLACK);
        mutex.unlock();
        Thread::wait(1000);
    }
    *timeNo = 0;
}

int main() {
    yes.mode(PullUp);
    no.mode(PullUp);
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    lcd.color(WHITE);
    
    lcd.printf("Initializing...");
    int answer = 1;
    bool flag = false;
    int response = -1;
    int score = 0;
    int time_count;
    int* timePointer = &time_count;
    int question_no = 0;
    bool endFlag = false;
    char* question = (char*) malloc(sizeof(char) * 150+1);;
    char* answerStr = (char*) malloc(sizeof(char)+1);;
    wait(2);
    lcd.cls();
    lcd.printf("press to start");
    while (yes == true && no == true) {}
    lcd.cls();
    lcd.printf("Quiz starts");
    wait(2);
    lcd.cls();
    lcd.printf("Ready");
    wait(2);
    //===========================
    int total_no_questions = 10;
    vector<int> question_inds(total_no_questions);
    for (int i=0; i<total_no_questions; i++) {
        question_inds[i] = i;
    }
    int randind;
    int rand_no;
    
    int max_question_no = 5; // maximum_number; assert it smaller than total_no_questions!!!
    //============================
    while (!endFlag) { 
        if (question_no == max_question_no) {
            lcd.cls();
            lcd.printf("Quiz ends");
            wait(2);
            endFlag = true;
            break;
        }
        srand(time(NULL));
        randind = (rand() % total_no_questions);
        total_no_questions--;
        rand_no = question_inds[randind];
        question_inds.erase(question_inds.begin() + randind);
        char file_name[100];
        char no_str[1];
        char txt[4];
        sprintf(no_str, "%d",rand_no);
        sprintf(txt, "%s", ".txt");
        strcpy(file_name, "/local/test");
        strncat(file_name, no_str,10);
        strncat(file_name, txt,10);
        FILE *f = fopen(file_name , "r"); 
        fgets(question, 150, f);
        fgets(answerStr, 150, f);
        char buffer[1];
        sprintf(buffer, "%s", answerStr);
        fclose(f);
        lcd.cls();
        lcd.printf("Next Question");
        wait(2);
        question_no++;
        if (buffer[0] == 't') {
            answer = 1;
        } else {
            answer = 0;
        }
        for (int i = 3; i > 0; i--) {
            lcd.cls();
            //lcd.text_char(i, 12, 12, RED);
            lcd.printf("%d",i);
            Thread::wait(1000);
        }
        lcd.color(WHITE);
        lcd.cls();
        lcd.locate(1,1);
        lcd.printf(question); // to be corrected
        lcd.locate(2,14);
        lcd.printf("Yes");
        lcd.locate(14,14);
        lcd.printf("No");
        lcd.locate(0,8);
        lcd.printf("%02d out of %02d", question_no, max_question_no);
        time_count = 10;
        Thread timerr(timer, (void *) timePointer);
        wait(0.1);
        while (time_count >= 0 && flag == false) {
            if (yes == true && no == true) {}
            else if (yes == true) {
                flag = true;
                response = 1;
            } else if (no == true) {
                flag = true;
                response = 0;
            }
            if (time_count == 0) {flag = true; response = -1;}
        }
        timerr.terminate();
        if (response == 1) {
            lcd.locate(2,14);
            if (response == answer) {
                lcd.textbackground_color(GREEN);
                lcd.printf("Yes");
                score++;
            } else {
                lcd.textbackground_color(RED);
                lcd.printf("Yes");
            }
        } else if (response == 0) {
            lcd.locate(14,14);
            if (response == answer) {
                lcd.textbackground_color(GREEN);
                lcd.printf("No");
                score++;
            } else {
                lcd.textbackground_color(RED);
                lcd.printf("No");
            }
        } else if (response == -1) {
            lcd.textbackground_color(RED);
            lcd.locate(2,14);
            lcd.printf("Yes");
            lcd.locate(14,14);
            lcd.printf("No");
        };
        wait(2);
        lcd.cls();
        lcd.locate(0,0);
        lcd.textbackground_color(BLACK);
        response = -2;
        flag = false;
    }
    lcd.cls();
    lcd.printf("Total Score: %2.2f", score/(question_no+0.0) * 100);
    while (true) {}
}