#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"

uLCD_4DGL lcd(p28, p27, p30);

Mutex stdio_mutex; 

DigitalOut latch(p15);
DigitalOut enable(p16);
DigitalOut led1(LED1);
 
SPI spi(p11, p12, p13);

void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

void shiftbrite(void const *args) {
    stdio_mutex.lock();
    int red=0;
    int green=0;
    int blue=0;
    int r=1;
    int g=1;
    int b=1;
    while(1) {
        if (r == 1){
            if (red <= 255) {red += 5;} else {r= 1-r;}
        } else {
            if (red >= 0) {red -= 5;} else {r= 1-r;}
        }
        if (b == 1){
            if (blue <= 255) {blue += 5;} else {b=!b;}
        } else {
            if (blue >= 0) {blue -= 5;} else {b=!b;}
        }
        if (g == 1){
            if (green <= 255) {green += 5;} else {g=!g;}
        } else {
            if (green >= 0) {green -= 5;} else {g=!g;}
        } 
        RGB_LED(red, green, blue);
        stdio_mutex.unlock();
        wait(5);
    }
}

void lcd1(void const *args) {
        stdio_mutex.lock();
        lcd.printf("music playing");
        stdio_mutex.unlock();
    //lcd.line(64,64,prevline_x,prevline_y, BLACK);
    //lcd.circle(prevcirc_x,prevcirc_y, 10, BLACK);
    //float line_x = 30*cos(heading*pi/180) + 64;
    //float line_y = 30*sin(heading*pi/180) + 64;
    //lcd.circle(64, 64, 30, GREEN);
    //lcd.line(64,64,line_x, line_y, BLUE);
}

int main() {
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    Thread t1(lcd1, (void *)"Th 1");
    Thread t2(shiftbrite, (void *)"Th 2");
    
    while (true) {
        led1 = !led1;
        Thread::wait(10);
    }

    //Thread t3(test_thread, (void *)"Th 3");
    
    //test_thread((void *)"Th 1");
}


